/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.opensearch.java;

import java.util.Arrays;

public record DocumentFieldNames(String name, String lockUntil, String lockedAt, String lockedBy) {
    public static final DocumentFieldNames DEFAULT = new DocumentFieldNames("name", "lockUntil", "lockedAt", "lockedBy");
    public static final DocumentFieldNames SNAKE_CASE = new DocumentFieldNames("name", "lock_until", "locked_at", "locked_by");

    public DocumentFieldNames {
        DocumentFieldNames.requireHasText(name, "name");
        DocumentFieldNames.requireHasText(lockUntil, "lockUntil");
        DocumentFieldNames.requireHasText(lockedAt, "lockedAt");
        DocumentFieldNames.requireHasText(lockedBy, "lockedBy");
        DocumentFieldNames.requireDistinct(name, lockUntil, lockedAt, lockedBy);
    }

    private static void requireHasText(String value, String field) {
        if (value == null || value.isBlank()) {
            throw new IllegalArgumentException("DocumentFieldNames." + field + " must not be blank");
        }
    }

    private static void requireDistinct(String ... values) {
        long distinct = Arrays.stream(values).distinct().count();
        if (distinct != (long)values.length) {
            throw new IllegalArgumentException("DocumentFieldNames must contain distinct field names");
        }
    }
}

