/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.opensearch.java;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockException;
import net.javacrumbs.shedlock.support.Utils;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.InlineScript;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.Result;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.opensearch.client.opensearch.core.UpdateResponse;
import org.opensearch.client.transport.httpclient5.ResponseException;

public class OpenSearchLockProvider
implements LockProvider {
    static final String SCHEDLOCK_DEFAULT_INDEX = "shedlock";
    static final String LOCK_UNTIL = "lockUntil";
    static final String LOCKED_AT = "lockedAt";
    static final String LOCKED_BY = "lockedBy";
    static final String NAME = "name";
    private static final String UPDATE_SCRIPT = "if (ctx._source.lockUntil <= params.lockedAt) { ctx._source.lockedBy = params.lockedBy; ctx._source.lockedAt = params.lockedAt; ctx._source.lockUntil =  params.lockUntil; } else { ctx.op = 'none' }";
    private static final String UNLOCK_UPDATE_SCRIPT = "ctx._source.lockUntil = params.unlockTime";
    private static final String PAINLESS_SCRIPT_LANG = "painless";
    private static final String UNLOCK_TIME = "unlockTime";
    private final OpenSearchClient openSearchClient;
    private final String hostname;
    private final String index;

    public OpenSearchLockProvider(OpenSearchClient openSearchClient) {
        this(openSearchClient, SCHEDLOCK_DEFAULT_INDEX);
    }

    public OpenSearchLockProvider(OpenSearchClient openSearchClient, String index) {
        this.openSearchClient = openSearchClient;
        this.index = index;
        this.hostname = Utils.getHostname();
    }

    public Optional<SimpleLock> lock(LockConfiguration lockConfiguration) {
        Instant now = ClockProvider.now();
        UpdateRequest<Object, Object> updateRequest = this.createUpdateRequest(lockConfiguration, now);
        try {
            UpdateResponse updateResponse = this.openSearchClient.update(updateRequest, Object.class);
            return updateResponse.result() == Result.NoOp ? Optional.empty() : Optional.of(new OpenSearchSimpleLock(lockConfiguration));
        }
        catch (IOException | OpenSearchException e) {
            if (OpenSearchLockProvider.isResponseExceptionWithConflictStatus((Exception)e) || OpenSearchLockProvider.isOpenSearchExceptionWithConflictStatus((Exception)e)) {
                return Optional.empty();
            }
            throw new LockException("Unexpected exception occurred", e);
        }
    }

    private static boolean isResponseExceptionWithConflictStatus(Exception e) {
        ResponseException ex;
        return e instanceof ResponseException && (ex = (ResponseException)e).status() == 409;
    }

    private static boolean isOpenSearchExceptionWithConflictStatus(Exception e) {
        OpenSearchException ex;
        return e instanceof OpenSearchException && (ex = (OpenSearchException)((Object)e)).status() == 409;
    }

    private UpdateRequest<Object, Object> createUpdateRequest(LockConfiguration lockConfiguration, Instant now) {
        Map<String, Object> lockObject = this.lockObject(lockConfiguration.getName(), lockConfiguration.getLockAtMostUntil(), now);
        return new UpdateRequest.Builder().index(this.index).script(this.createUpdateScript(lockConfiguration, now)).id(lockConfiguration.getName()).refresh(Refresh.True).upsert(lockObject).build();
    }

    private Script createUpdateScript(LockConfiguration lockConfiguration, Instant now) {
        Map<String, JsonData> updateScriptParams = this.updateScriptParams(lockConfiguration.getName(), lockConfiguration.getLockAtMostUntil(), now);
        InlineScript inlineScript = InlineScript.of(builder -> ((InlineScript.Builder)builder.source(UPDATE_SCRIPT).params(updateScriptParams)).lang(PAINLESS_SCRIPT_LANG));
        return Script.of(scriptBuilder -> scriptBuilder.inline(inlineScript));
    }

    private Map<String, Object> lockObject(String name, Instant lockUntil, Instant lockedAt) {
        return Map.of(NAME, name, LOCKED_BY, this.hostname, LOCKED_AT, lockedAt.toEpochMilli(), LOCK_UNTIL, lockUntil.toEpochMilli());
    }

    private Map<String, JsonData> updateScriptParams(String name, Instant lockUntil, Instant lockedAt) {
        return Map.of(NAME, JsonData.of((Object)name), LOCKED_BY, JsonData.of((Object)this.hostname), LOCKED_AT, JsonData.of((Object)lockedAt.toEpochMilli()), LOCK_UNTIL, JsonData.of((Object)lockUntil.toEpochMilli()));
    }

    private final class OpenSearchSimpleLock
    extends AbstractSimpleLock {
        private OpenSearchSimpleLock(LockConfiguration lockConfiguration) {
            super(lockConfiguration);
        }

        public void doUnlock() {
            Map<String, JsonData> unlockParams = Map.of(OpenSearchLockProvider.UNLOCK_TIME, JsonData.of((Object)this.lockConfiguration.getUnlockTime().toEpochMilli()));
            InlineScript inlineScript = InlineScript.of(builder -> ((InlineScript.Builder)builder.source(OpenSearchLockProvider.UNLOCK_UPDATE_SCRIPT).params(unlockParams)).lang(OpenSearchLockProvider.PAINLESS_SCRIPT_LANG));
            Script unlockScript = Script.of(scriptBuilder -> scriptBuilder.inline(inlineScript));
            UpdateRequest unlockUpdateRequest = new UpdateRequest.Builder().index(OpenSearchLockProvider.this.index).script(unlockScript).id(this.lockConfiguration.getName()).refresh(Refresh.True).build();
            try {
                OpenSearchLockProvider.this.openSearchClient.update(unlockUpdateRequest, Object.class);
            }
            catch (IOException | OpenSearchException e) {
                this.throwLockException((Exception)e);
            }
        }

        private void throwLockException(Exception e) {
            throw new LockException("Unexpected exception occurred", (Throwable)e);
        }
    }
}

