/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.test.base;

import java.io.StringReader;
import java.math.BigDecimal;
import net.javacrumbs.jsonunit.JsonMatchers;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import net.javacrumbs.jsonunit.core.ConfigurationWhen;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import net.javacrumbs.jsonunit.fluent.JsonFluentAssert;
import net.javacrumbs.jsonunit.test.base.RecordingDifferenceListener;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public abstract class AbstractJsonFluentAssertTest {
    @Test
    void testAssertString() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").isEqualTo((Object)"{\"test\":2}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <2> but was: <1>.\n");
    }

    @Test
    void testAssertDifferentType() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":\"1\"}").node("test").isEqualTo((Object)"1")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <1> but was: <\"1\">.\n");
    }

    @Test
    void testAssertDifferentTypeInt() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":\"1\"}").node("test").isEqualTo((Object)1)).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <1> but was: <\"1\">.\n");
    }

    @Test
    void shouldCompareDecimals() {
        JsonFluentAssert.assertThatJson((Object)"{\"a\": 1.0, \"b\": 1.00}").node("b").isEqualTo((Object)"1.00");
    }

    @Test
    void testAssertTolerance() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":1.00001}").node("test").withTolerance(0.001).isEqualTo((Object)1);
    }

    @Test
    void shouldAssertEmptyArray() {
        JsonFluentAssert.assertThatJson((Object)"{\"root\":[]}").node("root").isArray().isEmpty();
    }

    @Test
    void shouldFailOnNonEmptyArray() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"root\":[1]}").node("root").isArray().isEmpty()).hasMessage("Node \"root\" is not an empty array.");
    }

    @Test
    void shouldAssertNonEmptyArray() {
        JsonFluentAssert.assertThatJson((Object)"{\"root\":[1]}").node("root").isArray().isNotEmpty();
    }

    @Test
    void shouldAssertNonEmptyArrayFailure() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"root\":[]}").node("root").isArray().isNotEmpty()).hasMessage("Node \"root\" is an empty array.");
    }

    @Test
    protected void shouldAllowUnquotedKeysAndCommentInExpectedValue() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").isEqualTo((Object)"{//comment\ntest:1}");
    }

    @Test
    void testAssertToleranceDifferentOrder() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":1.00001}").withTolerance(0.001).node("test").isEqualTo((Object)1);
    }

    @Test
    void testAssertToleranceDirect() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":1.00001}").withTolerance(0.001).isEqualTo((Object)"{\"test\":1}");
    }

    @Test
    void testAssertToleranceFailure() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":1.1}").node("test").withTolerance(0.001).isEqualTo((Object)1)).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <1> but was: <1.1>, difference is 0.1, tolerance is 0.001\n");
    }

    @Test
    void testAssertZeroToleranceFailure() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":1.1}").node("test").withTolerance(0.0).isEqualTo((Object)1)).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <1> but was: <1.1>.\n");
    }

    @Test
    void testAssertNode() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)this.readValue("{\"test\":1}")).isEqualTo(this.readValue("{\"test\":2}"))).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <2> but was: <1>.\n");
    }

    @Test
    void testAssertNodeInExpectOnly() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").isEqualTo(this.readValue("{\"test\":2}"))).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <2> but was: <1>.\n");
    }

    @Test
    void testAssertReader() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)new StringReader("{\"test\":1}")).isEqualTo((Object)new StringReader("{\"test\":2}"))).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <2> but was: <1>.\n");
    }

    @Test
    void testOk() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").isEqualTo((Object)"{\"test\":1}");
    }

    @Test
    void testArray() {
        JsonFluentAssert.assertThatJson((Object)"[1, 2]").node("[0]").isEqualTo((Object)1);
    }

    @Test
    void testOkNumber() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").node("test").isEqualTo((Object)1);
    }

    @Test
    void testOkNumberInString() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").node("test").isEqualTo((Object)"1");
    }

    @Test
    void testOkFloat() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":1.1}").node("test").isEqualTo((Object)1.1);
    }

    @Test
    void testOkNull() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":null}").node("test").isEqualTo(null);
    }

    @Test
    void testNotEqualTo() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").isNotEqualTo((Object)"{\"test\": 1}")).hasMessage("JSON is equal.");
    }

    @Test
    void testAssertPath() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").node("test").isEqualTo((Object)"2")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <2> but was: <1>.\n");
    }

    @Test
    void testAssertPathWithDescription() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)JsonUtils.jsonSource((Object)"{\"test\":1}", (String)"$")).node("test").isEqualTo((Object)"2")).hasMessage("JSON documents are different:\nDifferent value found in node \"$.test\", expected: <2> but was: <1>.\n");
    }

    @Test
    void testPresentWithDescription() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)JsonUtils.jsonSource((Object)"{\"test\":1}", (String)"$")).node("test2").isPresent()).hasMessage("Different value found in node \"$.test2\", expected: <node to be present> but was: <missing>.");
    }

    @Test
    void testAssertPathArray() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"root\":{\"test\":[1,2,3]}}").node("root.test[0]").isEqualTo((Object)2)).hasMessage("JSON documents are different:\nDifferent value found in node \"root.test[0]\", expected: <2> but was: <1>.\n");
    }

    @Test
    void testAssertPathArrayOk() {
        JsonFluentAssert.assertThatJson((Object)"{\"root\":{\"test\":[1,2,3]}}").node("root.test[1]").isEqualTo((Object)2);
    }

    @Test
    void testLongPaths() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"root\":{\"test\":1}}").node("root.test").isEqualTo((Object)"2")).hasMessage("JSON documents are different:\nDifferent value found in node \"root.test\", expected: <2> but was: <1>.\n");
    }

    @Test
    void testMoreNodes() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test1\":2, \"test2\":1}").node("test1").isEqualTo((Object)2).node("test2").isEqualTo((Object)2)).hasMessage("JSON documents are different:\nDifferent value found in node \"test2\", expected: <2> but was: <1>.\n");
    }

    @Test
    void testCompareArrays() {
        JsonFluentAssert.assertThatJson((Object)"[{\"b\": 10}]").isEqualTo(JsonAssertions.json((Object)"[{\"b\": 10}]"));
    }

    @Test
    void testCompareArraysIgnoringChildOrder() {
        JsonFluentAssert.assertThatJson((Object)"[[1,2],[3,4],[5,6]]").when(ConfigurationWhen.path((String)"[*]"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0])}).isEqualTo(JsonAssertions.json((Object)"[[2,1],[4,3],[6,5]]"));
    }

    @Test
    void testCompareDifferentArraysIgnoringChildOrder() {
        JsonFluentAssert.assertThatJson((Object)"[[1,2],[3,4],[5,6]]").when(ConfigurationWhen.path((String)"[*]"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0])}).isNotEqualTo(JsonAssertions.json((Object)"[[4,3],[6,5],[2,1]]"));
    }

    @Test
    void testCompareArraysIgnoringChildOrderAndExtraElements() {
        JsonFluentAssert.assertThatJson((Object)"[[1,2,3],[3,4,5],[5,6,7]]").when(ConfigurationWhen.path((String)"[*]"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[]{Option.IGNORING_EXTRA_ARRAY_ITEMS})}).isEqualTo(JsonAssertions.json((Object)"[[2,1],[4,3],[6,5]]"));
    }

    @Test
    void testCompareArraysIgnoringChildOrderAndParentExtraElements() {
        JsonFluentAssert.assertThatJson((Object)"[[1,2],[3,4],[5,6],[7,8]]").when(ConfigurationWhen.path((String)"[*]"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0])}).when(ConfigurationWhen.rootPath(), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_EXTRA_ARRAY_ITEMS, (Option[])new Option[0])}).isEqualTo(JsonAssertions.json((Object)"[[2,1],[4,3],[6,5]]"));
    }

    @Test
    void testNodeAbsent() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test1\":2, \"test2\":1}").node("test2").isAbsent()).hasMessage("Different value found in node \"test2\", expected: <node to be absent> but was: <1>.");
    }

    @Test
    void testNodeAbsentOk() {
        JsonFluentAssert.assertThatJson((Object)"{\"test1\":2, \"test2\":1}").node("test3").isAbsent();
    }

    @Test
    void shouldTreatNullAsAbsent() {
        JsonFluentAssert.assertThatJson((Object)"{\"a\":1, \"b\": null}").when(Option.TREATING_NULL_AS_ABSENT, new Option[0]).node("b").isAbsent();
    }

    @Test
    void testNodePresent() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test1\":2, \"test2\":1}").node("test3").isPresent()).hasMessage("Different value found in node \"test3\", expected: <node to be present> but was: <missing>.");
    }

    @Test
    void testNodePresentOk() {
        JsonFluentAssert.assertThatJson((Object)"{\"test1\":2, \"test2\":1}").node("test2").isPresent();
    }

    @Test
    void testNodePresentNull() {
        JsonFluentAssert.assertThatJson((Object)"{\"test1\":2, \"test2\":null}").node("test2").isPresent();
    }

    @Test
    void isPresentShouldTreatNullAsAbsentWhenSpecified() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test1\":2, \"test2\":null}").when(Option.TREATING_NULL_AS_ABSENT, new Option[0]).node("test2").isPresent()).hasMessage("Different value found in node \"test2\", expected: <node to be present> but was: <missing>.");
    }

    @Test
    void shouldAllowWeirdCharsInArrayPattern() {
        JsonFluentAssert.assertThatJson((Object)"{\"root\": {\n  \"@id\" : \"urn:uuid:50aa37c0-eef0-4d72-9f32-17ebbcf17c10\",\n  \"@graph\" : [\n    { \"foo\" : \"bar\" }\n  ]\n}}").node("root.@graph[0].foo").isEqualTo((Object)"bar");
    }

    @Test
    void testMessage() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").as("Test is different").isEqualTo((Object)"{\"test\":2}")).hasMessage("[Test is different] JSON documents are different:\nDifferent value found in node \"test\", expected: <2> but was: <1>.\n");
    }

    @Test
    void testIgnore() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").isEqualTo((Object)"{\"test\":\"${json-unit.ignore}\"}");
    }

    @Test
    void testIgnoreHash() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").isEqualTo((Object)"{\"test\":\"#{json-unit.ignore}\"}");
    }

    @Test
    void testIgnoreDifferent() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").ignoring("##IGNORE##").isEqualTo((Object)"{\"test\":\"##IGNORE##\"}");
    }

    @Test
    void anyNumberShouldAcceptAnInt() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").isEqualTo((Object)"{\"test\":\"${json-unit.any-number}\"}");
    }

    @Test
    void anyNumberShouldAcceptAFloat() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":1.1}").isEqualTo((Object)"{\"test\":\"${json-unit.any-number}\"}");
    }

    @Test
    void anyNumberShouldFailOnString() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":\"one\"}").isEqualTo((Object)"{\"test\":\"#{json-unit.any-number}\"}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <a number> but was: <\"one\">.\n");
    }

    @Test
    void anyNumberShouldFailOnNull() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":null}").isEqualTo((Object)"{\"test\":\"${json-unit.any-number}\"}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <a number> but was: <null>.\n");
    }

    @Test
    void anyNumberShouldFailOnObject() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":{\"a\":1}}").isEqualTo((Object)"{\"test\":\"${json-unit.any-number}\"}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <a number> but was: <{\"a\":1}>.\n");
    }

    @Test
    void anyBooleanShouldAcceptTrue() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":true}").isEqualTo((Object)"{\"test\":\"${json-unit.any-boolean}\"}");
    }

    @Test
    void anyBooleanShouldFailOnString() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":\"true\"}").isEqualTo((Object)"{\"test\":\"#{json-unit.any-boolean}\"}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <a boolean> but was: <\"true\">.\n");
    }

    @Test
    void anyBooleanShouldFailOnNull() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":null}").isEqualTo((Object)"{\"test\":\"${json-unit.any-boolean}\"}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <a boolean> but was: <null>.\n");
    }

    @Test
    void anyBooleanShouldFailOnObject() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":{\"a\":1}}").isEqualTo((Object)"{\"test\":\"${json-unit.any-boolean}\"}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <a boolean> but was: <{\"a\":1}>.\n");
    }

    @Test
    void anyStringShouldAcceptAString() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":\"value\"}").isEqualTo((Object)"{\"test\":\"${json-unit.any-string}\"}");
    }

    @Test
    void anyStringShouldFailOnBoolean() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":true}").isEqualTo((Object)"{\"test\":\"#{json-unit.any-string}\"}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <a string> but was: <true>.\n");
    }

    @Test
    void anyStringShouldFailOnNull() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":null}").isEqualTo((Object)"{\"test\":\"${json-unit.any-string}\"}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <a string> but was: <null>.\n");
    }

    @Test
    void anyStringShouldFailOnObject() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":{\"a\":1}}").isEqualTo((Object)"{\"test\":\"${json-unit.any-string}\"}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <a string> but was: <{\"a\":1}>.\n");
    }

    @Test
    void emptinessCheck() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":{}}").node("test").isEqualTo((Object)"{}");
    }

    @Test
    void ifMatcherDoesNotMatchReportDifference() {
        RecordingDifferenceListener listener = new RecordingDifferenceListener();
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":-1}").withMatcher("positive", Matchers.greaterThan((Comparable)BigDecimal.valueOf(0L))).withDifferenceListener((DifferenceListener)listener).isEqualTo((Object)"{\"test\": \"#{json-unit.matches:positive}\"}")).hasMessage("JSON documents are different:\nMatcher \"positive\" does not match value -1 in node \"test\". Expected a value greater than <0> but <-1> was less than <0>\n");
        Assertions.assertThat(listener.getDifferenceList()).hasSize(1);
        Assertions.assertThat((String)listener.getDifferenceList().get(0).toString()).isEqualTo("DIFFERENT Expected #{json-unit.matches:positive} in test got -1 in test");
    }

    @Test
    void testLogging() {
        JsonFluentAssert.assertThatJson((Object)"[\"foo\", \"bar\"]").isArray().ofLength(2).thatContains((Object)"foo").thatContains((Object)"bar");
    }

    @Test
    void shoulEscapeDot() {
        JsonFluentAssert.assertThatJson((Object)"{\"name.with.dot\": \"value\"}").node("name\\.with\\.dot").isStringEqualTo("value");
    }

    @Test
    void shoulEscapeDotWithArray() {
        JsonFluentAssert.assertThatJson((Object)"{\"errors\":{\"days[0].date\":[\"validation.failed\"]}}").node("errors.days[0]\\.date").isArray();
    }

    @Test
    void comparisonShouldFailOnDifferentType() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").isEqualTo((Object)"{\"test\":\"1\"}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <\"1\"> but was: <1>.\n");
    }

    @Test
    void pathShouldBeIgnoredForExtraKey() {
        JsonFluentAssert.assertThatJson((Object)"{\"root\":{\"test\":1, \"ignored\": 1}}").whenIgnoringPaths(new String[]{"root.ignored"}).isEqualTo((Object)"{\"root\":{\"test\":1}}");
    }

    @Test
    void pathShouldBeIgnoredForDifferentValue() {
        JsonFluentAssert.assertThatJson((Object)"{\"root\":{\"test\":1, \"ignored\": 1}}").whenIgnoringPaths(new String[]{"root.ignored"}).isEqualTo((Object)"{\"root\":{\"test\":1, \"ignored\": 2}}");
    }

    @Test
    void testEqualsToArray() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":[1,2,3]}").node("test").isEqualTo((Object)new int[]{1, 2, 3});
    }

    @Test
    void testEqualsToDoubleArray() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":[1.0,2.0,3.0]}").node("test").isEqualTo((Object)new double[]{1.0, 2.0, 3.0});
    }

    @Test
    void isArrayShouldFailIfArrayDoesNotExist() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").node("test2").isArray()).hasMessage("Different value found in node \"test2\", expected: <array> but was: <missing>.");
    }

    @Test
    void isArrayShouldFailIfItIsNotArray() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":\"1\"}").node("test").isArray()).hasMessage("Node \"test\" has invalid type, expected: <array> but was: <\"1\">.");
    }

    @Test
    void arrayOfLengthShouldFailOnIncorrectSize() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":[1,2,3]}").node("test").isArray().ofLength(2)).hasMessage("Node \"test\" has invalid length, expected: <2> but was: <3>.");
    }

    @Test
    void shouldReportExtraArrayItemsWhenNotIgnoringOrder() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":[1,2,3]}").node("test").isEqualTo((Object)"[1]")).hasMessage("JSON documents are different:\nArray \"test\" has different length, expected: <1> but was: <3>.\nArray \"test\" has different content. Extra values: [2, 3], expected: <[1]> but was: <[1,2,3]>\n");
    }

    @Test
    void shouldReportExtraArrayItemsWhenIgnoringOrder() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":[1,2,3]}").node("test").when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)"[1]")).hasMessage("JSON documents are different:\nArray \"test\" has different length, expected: <1> but was: <3>.\nArray \"test\" has different content. Missing values: [], extra values: [2, 3], expected: <[1]> but was: <[1,2,3]>\n");
    }

    @Test
    void shouldReportMissingArrayItemsWhenNotIgnoringOrder() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":[1]}").node("test").isEqualTo((Object)"[1, 2, 3]")).hasMessage("JSON documents are different:\nArray \"test\" has different length, expected: <3> but was: <1>.\nArray \"test\" has different content. Missing values: [2, 3], expected: <[1,2,3]> but was: <[1]>\n");
    }

    @Test
    void shouldReportMissingArrayItemsWhenIgnoringOrder() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":[1]}").node("test").when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)"[1, 2, 3]")).hasMessage("JSON documents are different:\nArray \"test\" has different length, expected: <3> but was: <1>.\nArray \"test\" has different content. Missing values: [2, 3], extra values: [], expected: <[1,2,3]> but was: <[1]>\n");
    }

    @Test
    void shouldReportExtraArrayItemsAndDifferencesWhenNotIgnoringOrder() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":[\"x\",\"b\",\"c\"]}").node("test").isEqualTo((Object)"[\"a\"]")).hasMessage("JSON documents are different:\nArray \"test\" has different length, expected: <1> but was: <3>.\nArray \"test\" has different content. Extra values: [\"b\", \"c\"], expected: <[\"a\"]> but was: <[\"x\",\"b\",\"c\"]>\nDifferent value found in node \"test[0]\", expected: <\"a\"> but was: <\"x\">.\n");
    }

    @Test
    void negativeArrayIndexShouldCountBackwards() {
        JsonFluentAssert.assertThatJson((Object)"{\"root\":{\"test\":[1,2,3]}}").node("root.test[-1]").isEqualTo((Object)3);
    }

    @Test
    void negativeArrayIndexShouldCountBackwardsAndReportFailure() {
        try {
            JsonFluentAssert.assertThatJson((Object)"{\"root\":{\"test\":[1,2,3]}}").node("root.test[-3]").isEqualTo((Object)3);
        }
        catch (AssertionError e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"JSON documents are different:\nDifferent value found in node \"root.test[-3]\", expected: <3> but was: <1>.\n", (Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    void negativeArrayIndexOutOfBounds() {
        try {
            JsonFluentAssert.assertThatJson((Object)"{\"root\":{\"test\":[1,2,3]}}").node("root.test[-5]").isEqualTo((Object)3);
        }
        catch (AssertionError e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"JSON documents are different:\nMissing node in path \"root.test[-5]\".\n", (Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    void positiveArrayIndexOutOfBounds() {
        try {
            JsonFluentAssert.assertThatJson((Object)"{\"root\":{\"test\":[1,2,3]}}").node("root.test[5]").isEqualTo((Object)3);
        }
        catch (AssertionError e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"JSON documents are different:\nMissing node in path \"root.test[5]\".\n", (Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    void arrayThatContainsShouldFailOnMissingNode() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":[{\"id\":36},{\"id\":37},{\"id\":38}]}").node("test").isArray().thatContains((Object)"{\"id\":42}")).hasMessage("Node \"test\" is '[{\"id\":36}, {\"id\":37}, {\"id\":38}]', expected to contain '{\"id\":42}'.");
    }

    @Test
    void testContains() {
        JsonFluentAssert.assertThatJson((Object)"[\"foo\", \"bar\"]").isArray().ofLength(2).thatContains((Object)"foo").thatContains((Object)"bar");
    }

    @Test
    void intValueShouldMatch() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").node("test").matches(CoreMatchers.equalTo((Object)BigDecimal.valueOf(1L)));
    }

    @Test
    void arrayContainsShouldMatch() {
        JsonFluentAssert.assertThatJson((Object)"[{\"a\": 7},8]").matches(CoreMatchers.hasItem((Matcher)JsonMatchers.jsonEquals((Object)"{\"a\": 7}")));
    }

    @Test
    void testArrayShouldMatchRegardlessOfOrder() {
        String actual = "{\"response\":[{\"attributes\":null,\"empolyees\":[{\"dob\":\"1987-03-21\",\"firstName\":\"Joe\",\"lastName\":\"Doe\"},{\"dob\":\"1986-02-12\",\"firstName\":\"Jason\",\"lastName\":\"Kowalski\"},{\"dob\":\"1985-01-11\",\"firstName\":\"Kate\",\"lastName\":\"Smith\"}],\"id\":123}]}";
        String expected = "{\"response\":[{\"attributes\":null,\"empolyees\":[{\"dob\":\"1985-01-11\",\"firstName\":\"Kate\",\"lastName\":\"Smith\"},{\"dob\":\"1986-02-12\",\"firstName\":\"Jason\",\"lastName\":\"Kowalski\"},{\"dob\":\"1987-03-21\",\"firstName\":\"Joe\",\"lastName\":\"Doe\"}],\"id\":123}]}";
        JsonFluentAssert.assertThatJson((Object)"{\"response\":[{\"attributes\":null,\"empolyees\":[{\"dob\":\"1987-03-21\",\"firstName\":\"Joe\",\"lastName\":\"Doe\"},{\"dob\":\"1986-02-12\",\"firstName\":\"Jason\",\"lastName\":\"Kowalski\"},{\"dob\":\"1985-01-11\",\"firstName\":\"Kate\",\"lastName\":\"Smith\"}],\"id\":123}]}").when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)"{\"response\":[{\"attributes\":null,\"empolyees\":[{\"dob\":\"1985-01-11\",\"firstName\":\"Kate\",\"lastName\":\"Smith\"},{\"dob\":\"1986-02-12\",\"firstName\":\"Jason\",\"lastName\":\"Kowalski\"},{\"dob\":\"1987-03-21\",\"firstName\":\"Joe\",\"lastName\":\"Doe\"}],\"id\":123}]}");
    }

    @Test
    void intValueShouldFailIfDoesNotMatch() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").node("test").matches(CoreMatchers.equalTo((Object)BigDecimal.valueOf(2L)))).hasMessage("Node \"test\" does not match.\nExpected: <2>\n     but: was <1>");
    }

    @Test
    void floatValueShouldMatch() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":1.10001}").node("test").matches(Matchers.closeTo((BigDecimal)BigDecimal.valueOf(1.1), (BigDecimal)BigDecimal.valueOf(0.001)));
    }

    @Test
    void floatValueShouldFailIfDoesNotMatch() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").node("test").matches(CoreMatchers.equalTo((Object)BigDecimal.valueOf(2L)))).hasMessage("Node \"test\" does not match.\nExpected: <2>\n     but: was <1>");
    }

    @Test
    void booleanValueShouldMatch() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":true}").node("test").matches(CoreMatchers.equalTo((Object)true));
    }

    @Test
    void booleanValueShouldFailIfDoesNotMatch() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test2\":true}").node("test2").matches(CoreMatchers.equalTo((Object)false))).hasMessage("Node \"test2\" does not match.\nExpected: <false>\n     but: was <true>");
    }

    @Test
    void missingValueShouldFail() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test2\":true}").node("test").matches(CoreMatchers.equalTo((Object)false))).hasMessage("Different value found in node \"test\", expected: <node to be present> but was: <missing>.");
    }

    @Test
    void stringValueShouldMatch() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":\"one\"}").node("test").matches(CoreMatchers.equalTo((Object)"one"));
    }

    @Test
    void stringValueShouldFailIfDoesNotMatch() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":\"one\"}").node("test").matches(CoreMatchers.equalTo((Object)"two"))).hasMessage("Node \"test\" does not match.\nExpected: \"two\"\n     but: was \"one\"");
    }

    @Test
    void nullValueShouldMatch() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":null}").node("test").matches(CoreMatchers.nullValue());
    }

    @Test
    void nullValueShouldFailIfDoesNotMatch() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":\"one\"}").node("test").matches(CoreMatchers.equalTo((Object)CoreMatchers.nullValue()))).hasMessage("Node \"test\" does not match.\nExpected: <null>\n     but: was \"one\"");
    }

    @Test
    void arrayShouldMatch() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":[1,2,3]}").node("test").matches(CoreMatchers.hasItem((Object)BigDecimal.valueOf(1L)));
    }

    @Test
    void arraySizeShouldMatch() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":[1,2,3]}").node("test").matches(Matchers.hasSize((int)3));
    }

    @Test
    void arrayMatcherShouldFailIfNotFound() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":[1,2,3]}").node("test").matches(CoreMatchers.hasItem((Object)4))).hasMessage("Node \"test\" does not match.\nExpected: a collection containing <4>\n     but: mismatches were: [was <1>, was <2>, was <3>]");
    }

    @Test
    void objectShouldMatch() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":[{\"value\":1},{\"value\":2},{\"value\":3}]}").node("test").matches(CoreMatchers.everyItem((Matcher)JsonMatchers.jsonPartMatches((String)"value", (Matcher)Matchers.lessThanOrEqualTo((Comparable)BigDecimal.valueOf(4L)))));
    }

    @Test
    void objectShouldMatchToMap() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":[{\"value\":1},{\"value\":2},{\"value\":3}]}").node("test").matches(CoreMatchers.hasItem((Matcher)Matchers.hasEntry((Object)"value", (Object)BigDecimal.valueOf(1L))));
    }

    @Test
    void objectMatcherShouldFailIfNotFound() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":[{\"value\":1},{\"value\":2},{\"value\":3}]}").node("test").matches(CoreMatchers.hasItem((Matcher)JsonMatchers.jsonPartEquals((String)"value", (Object)4)))).hasMessage("Node \"test\" does not match.\nExpected: a collection containing 4 in \"value\"\n     but: mismatches were: [JSON documents are different:\nDifferent value found in node \"value\", expected <4> but was <1>.\n, JSON documents are different:\nDifferent value found in node \"value\", expected <4> but was <2>.\n, JSON documents are different:\nDifferent value found in node \"value\", expected <4> but was <3>.\n]");
    }

    @Test
    void isStringShouldFailIfItDoesNotExist() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").node("test2").isString()).hasMessage("Different value found in node \"test2\", expected: <string> but was: <missing>.");
    }

    @Test
    void shouldChainStringEquals() {
        JsonFluentAssert.assertThatJson((Object)"{ \"key1\": \"[value1]\", \"key2\": \"[value2]\" }").node("key1").isStringEqualTo("[value1]").node("key2").isStringEqualTo("[value2]");
    }

    @Test
    void isStringShouldFailIfItIsNotAString() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").node("test").isString()).hasMessage("Node \"test\" has invalid type, expected: <string> but was: <1>.");
    }

    @Test
    void isStringEqualToShouldFailIfItIsNotAString() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").node("test").isStringEqualTo("1")).hasMessage("Node \"test\" has invalid type, expected: <string> but was: <1>.");
    }

    @Test
    void isStringEqualToShouldFailIfItDiffers() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":\"2\"}").node("test").isStringEqualTo("1")).hasMessage("Different value found in node \"test\", expected: <\"1\"> but was: <\"2\">.");
    }

    @Test
    void isStringEqualToShouldPass() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":\"1\"}").node("test").isStringEqualTo("1");
    }

    @Test
    void equalsShouldFailOnStringAndANumber() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":\"1\"}").node("test").isEqualTo((Object)"1")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <1> but was: <\"1\">.\n");
    }

    @Test
    void isStringShouldFailOnNull() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":null}").node("test").isStringEqualTo("1")).hasMessage("Node \"test\" has invalid type, expected: <string> but was: <null>.");
    }

    @Test
    void isStringShouldPass() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":\"1\"}").node("test").isString();
    }

    @Test
    void arrayOfLengthShouldPass() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":[1,2,3]}").node("test").isArray().ofLength(3);
    }

    @Test
    void arrayThatContainsShouldPass() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":[{\"id\":36},{\"id\":37},{\"id\":38}]}").node("test").isArray().thatContains((Object)"{\"id\":37}");
    }

    @Test
    void isObjectShouldPassOnObject() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":{\"a\":true}}").node("test").isObject();
    }

    @Test
    void isObjectShouldFailOnBoolean() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":{\"a\":true}}").node("test.a").isObject()).hasMessage("Node \"test.a\" has invalid type, expected: <object> but was: <true>.");
    }

    @Test
    void isObjectShouldFailOnMissing() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":{\"a\":true}}").node("test.b").isObject()).hasMessage("Different value found in node \"test.b\", expected: <object> but was: <missing>.");
    }

    @Test
    void testNotEqualsToToArray() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":[1,2,3]}").node("test").isNotEqualTo((Object)new int[]{1, 2, 3})).hasMessage("JSON is equal.");
    }

    @Test
    void testEqualsToBoolean() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":true}").node("test").isEqualTo((Object)true);
    }

    @Test
    void testEqualsToNull() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":null}").node("test").isEqualTo(null);
    }

    @Test
    void testEqualsToNullFail() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").node("test").isEqualTo(null)).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <null> but was: <1>.\n");
    }

    @Test
    void testNotEqualsToNull() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":1}").node("test").isNotEqualTo(null);
    }

    @Test
    void testIssue3() {
        JsonFluentAssert.assertThatJson((Object)"{\"someKey\":\"111 text\"}").node("someKey").isEqualTo((Object)"\"111 text\"");
    }

    @Test
    void testIssue3NoSpace() {
        JsonFluentAssert.assertThatJson((Object)"{\"someKey\":\"111text\"}").node("someKey").isEqualTo((Object)"\"111text\"");
    }

    @Test
    void testIssue3SpaceStrings() {
        JsonFluentAssert.assertThatJson((Object)"{\"someKey\":\"a b\"}").node("someKey").isEqualTo((Object)"a b");
    }

    @Test
    void testIssue3Original() {
        JsonFluentAssert.assertThatJson((Object)"{\"someKey\":\"111 text\"}").node("someKey").isEqualTo((Object)"111 text");
    }

    @Test
    void testNullAndAbsent() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"test\":{\"a\":1, \"b\": null}}").isEqualTo((Object)"{\"test\":{\"a\":1}}")).hasMessage("JSON documents are different:\nDifferent keys found in node \"test\", extra: \"test.b\", expected: <{\"a\":1}> but was: <{\"a\":1,\"b\":null}>\n");
    }

    @Test
    void testTreatNullAsAbsent() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":{\"a\":1, \"b\": null}}").when(Option.TREATING_NULL_AS_ABSENT, new Option[0]).isEqualTo((Object)"{\"test\":{\"a\":1}}");
    }

    @Test
    void shouldIgnoreExtraFields() {
        JsonFluentAssert.assertThatJson((Object)"{\"test\":{\"a\":1, \"b\":2, \"c\":3}}").when(Option.IGNORING_EXTRA_FIELDS, new Option[0]).isEqualTo((Object)"{\"test\":{\"b\":2}}");
    }

    @Test
    void shouldAcceptEscapedPath() {
        JsonFluentAssert.assertThatJson((Object)"{\"foo.bar\":\"baz\"}").node("foo\\.bar").isEqualTo((Object)"baz");
    }

    @Test
    void shouldAcceptEscapedPathWithTwoDots() {
        JsonFluentAssert.assertThatJson((Object)"{\"foo.bar.baz\":\"baz\"}").node("foo\\.bar\\.baz").isEqualTo((Object)"baz");
    }

    @Test
    void shouldAcceptEscapedPathAndShowCorrectErrorMessage() {
        Assertions.assertThatThrownBy(() -> JsonFluentAssert.assertThatJson((Object)"{\"foo.bar\":\"boo\"}").node("foo\\.bar").isEqualTo((Object)"baz")).hasMessage("JSON documents are different:\nDifferent value found in node \"foo\\.bar\", expected: <\"baz\"> but was: <\"boo\">.\n");
    }

    protected abstract Object readValue(String var1);
}

