/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.spring;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpMessage;
import org.springframework.http.MediaType;
import org.springframework.test.web.reactive.server.EntityExchangeResult;

class Utils {
    Utils() {
    }

    static String getContentAsString(EntityExchangeResult<byte[]> result) {
        Charset charset = Utils.getCharset(result);
        return new String((byte[])result.getResponseBody(), charset);
    }

    private static @NonNull Charset getCharset(EntityExchangeResult<byte[]> result) {
        return Utils.getCharset(result.getResponseHeaders().getContentType());
    }

    static @NonNull Charset getCharset(HttpMessage message) {
        return Utils.getCharset(message.getHeaders().getContentType());
    }

    private static @NonNull Charset getCharset(@Nullable MediaType contentType) {
        if (contentType != null && contentType.getCharset() != null) {
            return contentType.getCharset();
        }
        return StandardCharsets.UTF_8;
    }
}

