/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.spring;

import java.util.function.Consumer;
import java.util.function.Function;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.internal.matchers.InternalMatcher;
import net.javacrumbs.jsonunit.spring.AbstractSpringMatcher;
import net.javacrumbs.jsonunit.spring.AbstractSpringMatchers;
import org.jspecify.annotations.NonNull;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.test.web.client.RequestMatcher;

public class JsonUnitRequestMatchers
extends AbstractSpringMatchers<JsonUnitRequestMatchers, RequestMatcher> {
    private JsonUnitRequestMatchers(Configuration configuration, Function<Object, Object> jsonTransformer) {
        super(configuration, jsonTransformer);
    }

    @Override
    @NonNull RequestMatcher matcher(@NonNull Consumer<InternalMatcher> matcher) {
        return new JsonRequestMatcher(this.configuration, matcher, this.jsonTransformer);
    }

    @Override
    @NonNull JsonUnitRequestMatchers matchers(@NonNull Configuration configuration, @NonNull Function<Object, Object> jsonTransformer) {
        return new JsonUnitRequestMatchers(configuration, jsonTransformer);
    }

    public static @NonNull JsonUnitRequestMatchers json() {
        return new JsonUnitRequestMatchers(Configuration.empty(), Function.identity());
    }

    private static class JsonRequestMatcher
    extends AbstractSpringMatcher
    implements RequestMatcher {
        private JsonRequestMatcher(@NonNull Configuration configuration, @NonNull Consumer<InternalMatcher> matcher, @NonNull Function<Object, Object> jsonTransformer) {
            super(configuration, matcher, jsonTransformer);
        }

        public void match(@NonNull ClientHttpRequest request) throws AssertionError {
            String actual = ((MockClientHttpRequest)request).getBodyAsString();
            this.doMatch(actual);
        }
    }
}

