/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.spring;

import java.math.BigDecimal;
import java.util.function.Consumer;
import java.util.function.Function;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.ConfigurationWhen;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.matchers.InternalMatcher;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import net.javacrumbs.jsonunit.jsonpath.JsonPathAdapter;
import org.hamcrest.Matcher;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

abstract class AbstractSpringMatchers<ME, MATCHER> {
    final Configuration configuration;
    final Function<Object, Object> jsonTransformer;

    AbstractSpringMatchers(@NonNull Configuration configuration, Function<Object, Object> jsonTransformer) {
        this.configuration = configuration;
        this.jsonTransformer = jsonTransformer;
    }

    abstract @NonNull MATCHER matcher(@NonNull Consumer<InternalMatcher> var1);

    abstract @NonNull ME matchers(@NonNull Configuration var1, @NonNull Function<Object, Object> var2);

    protected ME matchers(@NonNull Configuration configuration) {
        return this.matchers(configuration, this.jsonTransformer);
    }

    public @NonNull ME node(String path) {
        return this.inPath(path);
    }

    public @NonNull ME inPath(String path) {
        return this.matchers(this.configuration, json -> JsonPathAdapter.inPath((Object)this.jsonTransformer.apply(json), (String)path));
    }

    public @NonNull ME ignoring(@NonNull String ignorePlaceholder) {
        return this.matchers(this.configuration.withIgnorePlaceholder(ignorePlaceholder));
    }

    public @NonNull ME withTolerance(double tolerance) {
        return this.withTolerance(BigDecimal.valueOf(tolerance));
    }

    public @NonNull ME withMatcher(@NonNull String matcherName, @NonNull Matcher<?> matcher) {
        return this.matchers(this.configuration.withMatcher(matcherName, matcher));
    }

    public @NonNull ME withTolerance(@Nullable BigDecimal tolerance) {
        return this.matchers(this.configuration.withTolerance(tolerance));
    }

    public @NonNull ME withDifferenceListener(@NonNull DifferenceListener differenceListener) {
        return this.matchers(this.configuration.withDifferenceListener(differenceListener));
    }

    public @NonNull ME when(@NonNull Option firstOption, Option ... otherOptions) {
        return this.matchers(this.configuration.withOptions(firstOption, otherOptions));
    }

    public @NonNull ME when(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ConfigurationWhen.PathsParam object, ConfigurationWhen.ApplicableForPath ... actions) {
        return this.matchers(this.configuration.when(object, actions));
    }

    public @NonNull MATCHER isEqualTo(@Nullable Object expected) {
        return this.matcher(ctx -> ctx.isEqualTo(expected));
    }

    public @NonNull MATCHER isStringEqualTo(@Nullable String expected) {
        return this.matcher(ctx -> ctx.isStringEqualTo(expected));
    }

    public @NonNull MATCHER isNotEqualTo(@Nullable Object expected) {
        return this.matcher(ctx -> ctx.isNotEqualTo(expected));
    }

    public @NonNull MATCHER isAbsent() {
        return this.matcher(ctx -> ctx.isAbsent());
    }

    public @NonNull MATCHER isPresent() {
        return this.matcher(InternalMatcher::isPresent);
    }

    public @NonNull MATCHER isArray() {
        return this.matcher(InternalMatcher::isArray);
    }

    public @NonNull MATCHER isObject() {
        return this.matcher(InternalMatcher::isObject);
    }

    public @NonNull MATCHER isString() {
        return this.matcher(InternalMatcher::isString);
    }

    public @NonNull MATCHER isNull() {
        return this.matcher(InternalMatcher::isNull);
    }

    public @NonNull MATCHER isNotNull() {
        return this.matcher(InternalMatcher::isNotNull);
    }

    public @NonNull MATCHER matches(@NonNull Matcher<?> matcher) {
        return this.matcher(ctx -> ctx.matches(matcher));
    }

    public @NonNull MATCHER isTrue() {
        return this.isEqualTo(true);
    }

    public @NonNull MATCHER isFalse() {
        return this.isEqualTo(false);
    }
}

