/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.spring;

import java.io.IOException;
import java.util.function.BiConsumer;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.internal.Path;
import net.javacrumbs.jsonunit.core.internal.matchers.InternalMatcher;
import net.javacrumbs.jsonunit.spring.AbstractSpringMatcher;
import net.javacrumbs.jsonunit.spring.AbstractSpringMatchers;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.test.web.client.RequestMatcher;

public class JsonUnitRequestMatchers
extends AbstractSpringMatchers<JsonUnitRequestMatchers, RequestMatcher> {
    private JsonUnitRequestMatchers(Path path, Configuration configuration) {
        super(path, configuration);
    }

    @Override
    RequestMatcher matcher(BiConsumer<Object, InternalMatcher> matcher) {
        return new JsonRequestMatcher(this.path, this.configuration, matcher);
    }

    @Override
    JsonUnitRequestMatchers matchers(Path path, Configuration configuration) {
        return new JsonUnitRequestMatchers(path, configuration);
    }

    public static JsonUnitRequestMatchers json() {
        return new JsonUnitRequestMatchers(Path.root(), Configuration.empty());
    }

    private static class JsonRequestMatcher
    extends AbstractSpringMatcher
    implements RequestMatcher {
        private JsonRequestMatcher(Path path, Configuration configuration, BiConsumer<Object, InternalMatcher> matcher) {
            super(path, configuration, matcher);
        }

        public void match(ClientHttpRequest request) throws IOException, AssertionError {
            String actual = ((MockClientHttpRequest)request).getBodyAsString();
            this.doMatch(actual);
        }
    }
}

