/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.jsonpath;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.EvaluationListener;
import com.jayway.jsonpath.PathNotFoundException;
import java.util.ArrayList;
import java.util.List;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.jsonpath.InternalJsonPathUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonPathAdapter {
    private JsonPathAdapter() {
    }

    @NotNull
    public static Object inPath(@Nullable Object json, @NotNull String path) {
        String normalizedPath = InternalJsonPathUtils.fromBracketNotation(path);
        try {
            MatchRecordingListener recordingListener = new MatchRecordingListener();
            Object value = InternalJsonPathUtils.readValue(Configuration.defaultConfiguration().addEvaluationListeners(new EvaluationListener[]{recordingListener}), json, path);
            return JsonUtils.jsonSource((Object)JsonUtils.wrapDeserializedObject(value), (String)normalizedPath, recordingListener.getMatchingPaths());
        }
        catch (PathNotFoundException e) {
            return JsonUtils.jsonSource((Object)JsonUtils.missingNode(), (String)normalizedPath);
        }
    }

    private static class MatchRecordingListener
    implements EvaluationListener {
        private final List<String> matchingPaths = new ArrayList<String>();

        private MatchRecordingListener() {
        }

        public EvaluationListener.EvaluationContinuation resultFound(EvaluationListener.FoundResult foundResult) {
            this.matchingPaths.add(InternalJsonPathUtils.fromBracketNotation(foundResult.path()));
            return EvaluationListener.EvaluationContinuation.CONTINUE;
        }

        public List<String> getMatchingPaths() {
            return this.matchingPaths;
        }
    }
}

