/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.jsonpath;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;

public class InternalJsonPathUtils {
    private InternalJsonPathUtils() {
    }

    public static Configuration resolveJsonPaths(Object json, Configuration configuration) {
        List<String> pathsToBeIgnored = InternalJsonPathUtils.resolveJsonPaths(json, configuration.getPathsToBeIgnored());
        List pathOptions = configuration.getPathOptions().stream().map(po -> {
            List<String> newPoPaths = InternalJsonPathUtils.resolveJsonPaths(json, po.getPaths());
            return po.withPaths(newPoPaths);
        }).collect(Collectors.toList());
        return configuration.whenIgnoringPaths(pathsToBeIgnored).withPathOptions(pathOptions);
    }

    private static List<String> resolveJsonPaths(Object json, Collection<String> paths) {
        com.jayway.jsonpath.Configuration conf = com.jayway.jsonpath.Configuration.builder().options(new Option[]{Option.AS_PATH_LIST, Option.SUPPRESS_EXCEPTIONS}).build();
        return paths.stream().flatMap(path -> {
            if (path.startsWith("$")) {
                List resolvedPaths = (List)InternalJsonPathUtils.readValue(conf, json, path);
                return resolvedPaths.stream().map(InternalJsonPathUtils::fromBracketNotation);
            }
            return Stream.of(path);
        }).collect(Collectors.toList());
    }

    static <T> T readValue(com.jayway.jsonpath.Configuration conf, Object json, String path) {
        if (json instanceof String) {
            return (T)JsonPath.using((com.jayway.jsonpath.Configuration)conf).parse((String)json).read(path, new Predicate[0]);
        }
        return (T)JsonPath.using((com.jayway.jsonpath.Configuration)conf).parse(JsonUtils.convertToJson((Object)json, (String)"actual").getValue()).read(path, new Predicate[0]);
    }

    static String fromBracketNotation(String path) {
        return path.replace("['", ".").replace("']", "");
    }
}

