/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.fluent;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Path;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class JsonFluentAssert {
    private static final String ACTUAL = "actual";
    private final Path path;
    private final Object actual;
    private final String description;
    private final Configuration configuration;

    private JsonFluentAssert(Object actual, Path path, String description, Configuration configuration) {
        if (actual == null) {
            throw new IllegalArgumentException("Can not make assertions about null JSON.");
        }
        this.path = path;
        this.actual = actual;
        this.description = description;
        this.configuration = configuration;
    }

    private JsonFluentAssert(Object actual, String pathPrefix) {
        this(actual, Path.create((String)"", (String)pathPrefix), "", Configuration.empty());
    }

    public static JsonFluentAssert assertThatJson(Object json) {
        return new JsonFluentAssert(JsonUtils.convertToJson((Object)json, (String)ACTUAL), JsonUtils.getPathPrefix((Object)json));
    }

    public JsonFluentAssertAfterAssertion isEqualTo(Object expected) {
        Diff diff = this.createDiff(expected, this.configuration);
        if (!diff.similar()) {
            this.failWithMessage(diff.differences());
        }
        return JsonFluentAssertAfterAssertion.wrap(this);
    }

    public JsonFluentAssertAfterAssertion isStringEqualTo(String expected) {
        this.isString();
        Node node = JsonUtils.getNode((Object)this.actual, (Path)this.path);
        if (!node.asText().equals(expected)) {
            this.failOnDifference(Diff.quoteTextValue((Object)expected), Diff.quoteTextValue((Object)node.asText()));
        }
        return JsonFluentAssertAfterAssertion.wrap(this);
    }

    private void failOnDifference(Object expected, Object actual) {
        this.failWithMessage(String.format("Different value found in node \"%s\", expected: <%s> but was: <%s>.", this.path, expected, actual));
    }

    public JsonFluentAssertAfterAssertion isNotEqualTo(Object expected) {
        Diff diff = this.createDiff(expected, this.configuration);
        if (diff.similar()) {
            this.failWithMessage("JSON is equal.");
        }
        return JsonFluentAssertAfterAssertion.wrap(this);
    }

    @Deprecated
    public JsonFluentAssertAfterAssertion hasSameStructureAs(Object expected) {
        Diff diff = this.createDiff(expected, this.configuration.withOptions(Option.COMPARING_ONLY_STRUCTURE, new Option[0]));
        if (!diff.similar()) {
            this.failWithMessage(diff.differences());
        }
        return JsonFluentAssertAfterAssertion.wrap(this);
    }

    public JsonFluentAssert node(String newPath) {
        return new JsonFluentAssert(this.actual, this.path.copy(newPath), this.description, this.configuration);
    }

    public JsonFluentAssert whenIgnoringPaths(String ... pathsToBeIgnored) {
        return new JsonFluentAssert(this.actual, this.path, this.description, this.configuration.whenIgnoringPaths(pathsToBeIgnored));
    }

    private Diff createDiff(Object expected, Configuration configuration) {
        return Diff.create((Object)expected, (Object)this.actual, (String)ACTUAL, (Path)this.path, (Configuration)configuration);
    }

    private void failWithMessage(String message) {
        if (this.description != null && this.description.length() > 0) {
            throw new AssertionError((Object)("[" + this.description + "] " + message));
        }
        throw new AssertionError((Object)message);
    }

    public JsonFluentAssert as(String description) {
        return this.describedAs(description);
    }

    public JsonFluentAssert describedAs(String description) {
        return new JsonFluentAssert(this.actual, this.path, description, this.configuration);
    }

    public JsonFluentAssert ignoring(String ignorePlaceholder) {
        return new JsonFluentAssert(this.actual, this.path, this.description, this.configuration.withIgnorePlaceholder(ignorePlaceholder));
    }

    public JsonFluentAssert withTolerance(double tolerance) {
        return this.withTolerance(BigDecimal.valueOf(tolerance));
    }

    public JsonFluentAssert withTolerance(BigDecimal tolerance) {
        return new JsonFluentAssert(this.actual, this.path, this.description, this.configuration.withTolerance(tolerance));
    }

    public JsonFluentAssert withMatcher(String matcherName, Matcher<?> matcher) {
        return new JsonFluentAssert(this.actual, this.path, this.description, this.configuration.withMatcher(matcherName, matcher));
    }

    @Deprecated
    public JsonFluentAssert treatingNullAsAbsent() {
        return this.when(Option.TREATING_NULL_AS_ABSENT, new Option[0]);
    }

    public JsonFluentAssert when(Option firstOption, Option ... otherOptions) {
        return new JsonFluentAssert(this.actual, this.path, this.description, this.configuration.withOptions(firstOption, otherOptions));
    }

    public JsonFluentAssertAfterAssertion isAbsent() {
        if (!JsonUtils.nodeAbsent((Object)this.actual, (Path)this.path, (Configuration)this.configuration)) {
            this.failOnDifference("node to be absent", Diff.quoteTextValue((Object)JsonUtils.getNode((Object)this.actual, (Path)this.path)));
        }
        return JsonFluentAssertAfterAssertion.wrap(this);
    }

    public JsonFluentAssertAfterAssertion isPresent() {
        return this.isPresent("node to be present");
    }

    private JsonFluentAssertAfterAssertion isPresent(String expectedValue) {
        if (JsonUtils.nodeAbsent((Object)this.actual, (Path)this.path, (Configuration)this.configuration)) {
            this.failOnDifference(expectedValue, "missing");
        }
        return JsonFluentAssertAfterAssertion.wrap(this);
    }

    public ArrayAssert isArray() {
        Node node = this.assertType(Node.NodeType.ARRAY);
        return new ArrayAssert(node.arrayElements());
    }

    private Node assertType(Node.NodeType type) {
        this.isPresent(type.getDescription());
        Node node = JsonUtils.getNode((Object)this.actual, (Path)this.path);
        if (node.getNodeType() != type) {
            this.failOnType(node, type);
        }
        return node;
    }

    public void isObject() {
        this.assertType(Node.NodeType.OBJECT);
    }

    public void isString() {
        this.assertType(Node.NodeType.STRING);
    }

    private void failOnType(Node node, Node.NodeType expectedType) {
        this.failWithMessage("Node \"" + this.path + "\" has invalid type, expected: <" + expectedType.getDescription() + "> but was: <" + Diff.quoteTextValue((Object)node.getValue()) + ">.");
    }

    public JsonFluentAssert matches(Matcher<?> matcher) {
        this.isPresent();
        JsonFluentAssert.match(this.actual, this.path, matcher);
        return this;
    }

    private static void match(Object value, Path path, Matcher<?> matcher) {
        Node node = JsonUtils.getNode((Object)value, (Path)path);
        MatcherAssert.assertThat((String)("Node \"" + path + "\" does not match."), (Object)node.getValue(), matcher);
    }

    public static class JsonFluentAssertAfterAssertion
    extends JsonFluentAssert {
        private static JsonFluentAssertAfterAssertion wrap(JsonFluentAssert assertion) {
            if (assertion instanceof JsonFluentAssertAfterAssertion) {
                return (JsonFluentAssertAfterAssertion)assertion;
            }
            return new JsonFluentAssertAfterAssertion(assertion.actual, assertion.path, assertion.description, assertion.configuration);
        }

        private JsonFluentAssertAfterAssertion(Object actual, Path path, String description, Configuration configuration) {
            super(actual, path, description, configuration);
        }

        @Override
        @Deprecated
        public JsonFluentAssert when(Option firstOption, Option ... otherOptions) {
            return super.when(firstOption, otherOptions);
        }

        @Override
        @Deprecated
        public JsonFluentAssert withTolerance(double tolerance) {
            return super.withTolerance(tolerance);
        }

        @Override
        @Deprecated
        public JsonFluentAssert withTolerance(BigDecimal tolerance) {
            return super.withTolerance(tolerance);
        }

        @Override
        @Deprecated
        public JsonFluentAssert ignoring(String ignorePlaceholder) {
            return super.ignoring(ignorePlaceholder);
        }

        @Override
        @Deprecated
        public JsonFluentAssert whenIgnoringPaths(String ... pathsToBeIgnored) {
            return super.whenIgnoringPaths(pathsToBeIgnored);
        }
    }

    public class ArrayAssert {
        private final List<Node> array;

        public ArrayAssert(Iterator<Node> array) {
            ArrayList<Node> list = new ArrayList<Node>();
            while (array.hasNext()) {
                list.add(array.next());
            }
            this.array = list;
        }

        public ArrayAssert ofLength(int expectedLength) {
            if (this.array.size() != expectedLength) {
                JsonFluentAssert.this.failWithMessage("Node \"" + JsonFluentAssert.this.path + "\" has invalid length, expected: <" + this.array.size() + "> but was: <" + expectedLength + ">.");
            }
            return this;
        }

        public ArrayAssert thatContains(Object expected) {
            for (Node node : this.array) {
                Diff diff = Diff.create((Object)expected, (Object)node, (String)JsonFluentAssert.ACTUAL, (String)"", (Configuration)JsonFluentAssert.this.configuration);
                if (!diff.similar()) continue;
                return this;
            }
            JsonFluentAssert.this.failWithMessage("Node \"" + JsonFluentAssert.this.path + "\" is '" + this.array.toString() + "', expected to contain '" + expected + "'.");
            return this;
        }
    }
}

