/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.fluent;

import java.math.BigDecimal;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;

public class JsonFluentAssert {
    private static final String ACTUAL = "actual";
    private final String path;
    private final Object actual;
    private final String description;
    private final Configuration configuration;

    protected JsonFluentAssert(Object actual, String path, String description, Configuration configuration) {
        if (actual == null) {
            throw new IllegalArgumentException("Can not make assertions about null JSON.");
        }
        this.path = path;
        this.actual = actual;
        this.description = description;
        this.configuration = configuration;
    }

    protected JsonFluentAssert(Object actual) {
        this(actual, "", "", Configuration.empty());
    }

    public static JsonFluentAssert assertThatJson(Object json) {
        return new JsonFluentAssert(JsonUtils.convertToJson((Object)json, (String)ACTUAL));
    }

    public JsonFluentAssert isEqualTo(Object expected) {
        Diff diff = this.createDiff(expected, this.configuration);
        if (!diff.similar()) {
            this.failWithMessage(diff.differences());
        }
        return this;
    }

    public JsonFluentAssert isNotEqualTo(Object expected) {
        Diff diff = this.createDiff(expected, this.configuration);
        if (diff.similar()) {
            this.failWithMessage("JSON is equal.");
        }
        return this;
    }

    public JsonFluentAssert hasSameStructureAs(Object expected) {
        Diff diff = this.createDiff(expected, this.configuration.withOptions(Option.COMPARING_ONLY_STRUCTURE, new Option[0]));
        if (!diff.similar()) {
            this.failWithMessage(diff.differences());
        }
        return this;
    }

    public JsonFluentAssert node(String path) {
        return new JsonFluentAssert(this.actual, path, this.description, this.configuration);
    }

    private Diff createDiff(Object expected, Configuration configuration) {
        return Diff.create((Object)expected, (Object)this.actual, (String)ACTUAL, (String)this.path, (Configuration)configuration);
    }

    private void failWithMessage(String message) {
        if (this.description != null && this.description.length() > 0) {
            throw new AssertionError((Object)("[" + this.description + "] " + message));
        }
        throw new AssertionError((Object)message);
    }

    public JsonFluentAssert as(String description) {
        return this.describedAs(description);
    }

    public JsonFluentAssert describedAs(String description) {
        return new JsonFluentAssert(this.actual, this.path, description, this.configuration);
    }

    public JsonFluentAssert ignoring(String ignorePlaceholder) {
        return new JsonFluentAssert(this.actual, this.path, this.description, this.configuration.withIgnorePlaceholder(ignorePlaceholder));
    }

    public JsonFluentAssert withTolerance(double tolerance) {
        return this.withTolerance(BigDecimal.valueOf(tolerance));
    }

    public JsonFluentAssert withTolerance(BigDecimal tolerance) {
        return new JsonFluentAssert(this.actual, this.path, this.description, this.configuration.withTolerance(tolerance));
    }

    @Deprecated
    public JsonFluentAssert treatingNullAsAbsent() {
        return this.when(Option.TREATING_NULL_AS_ABSENT, new Option[0]);
    }

    public JsonFluentAssert when(Option firstOption, Option ... otherOptions) {
        return new JsonFluentAssert(this.actual, this.path, this.description, this.configuration.withOptions(firstOption, otherOptions));
    }

    public JsonFluentAssert isAbsent() {
        if (JsonUtils.nodeExists((Object)this.actual, (String)this.path)) {
            this.failWithMessage("Node \"" + this.path + "\" is present.");
        }
        return this;
    }

    public JsonFluentAssert isPresent() {
        if (!JsonUtils.nodeExists((Object)this.actual, (String)this.path)) {
            this.failWithMessage("Node \"" + this.path + "\" is missing.");
        }
        return this;
    }
}

