/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.fluent;

import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import org.codehaus.jackson.JsonNode;

public class JsonAssert {
    private static final String EXPECTED = "expected";
    private static final String ACTUAL = "actual";
    private static final String DEFAULT_IGNORE_PLACEHOLDER = "${json-unit.ignore}";
    private final String path;
    private final JsonNode actual;
    private final String description;
    private final String ignorePlaceholder;

    protected JsonAssert(JsonNode actual, String path, String description, String ignorePlaceholder) {
        if (actual == null) {
            throw new IllegalArgumentException("Can not make assertions about null JSON.");
        }
        this.path = path;
        this.actual = actual;
        this.description = description;
        this.ignorePlaceholder = ignorePlaceholder;
    }

    public JsonAssert(JsonNode actual) {
        this(actual, "", "", DEFAULT_IGNORE_PLACEHOLDER);
    }

    public static JsonAssert assertThatJson(JsonNode json) {
        return new JsonAssert(json);
    }

    public static JsonAssert assertThatJson(Object json) {
        return JsonAssert.assertThatJson(JsonUtils.convertToJson((Object)json, (String)ACTUAL));
    }

    public JsonAssert isEqualTo(JsonNode expected) {
        Diff diff = new Diff(expected, this.actual, this.path, this.ignorePlaceholder);
        if (!diff.similar()) {
            this.failWithMessage(diff.differences());
        }
        return this;
    }

    public JsonAssert isEqualTo(Object expected) {
        return this.isEqualTo(JsonUtils.convertToJson((Object)expected, (String)EXPECTED));
    }

    public JsonAssert isNotEqualTo(JsonNode expected) {
        Diff diff = new Diff(expected, this.actual, this.path, this.ignorePlaceholder);
        if (diff.similar()) {
            this.failWithMessage("JSON is equal.");
        }
        return this;
    }

    public JsonAssert isNotEqualTo(Object expected) {
        return this.isNotEqualTo(JsonUtils.convertToJson((Object)expected, (String)EXPECTED));
    }

    public JsonAssert hasSameStructureAs(JsonNode expected) {
        Diff diff = new Diff(expected, this.actual, this.path, this.ignorePlaceholder);
        if (!diff.similarStructure()) {
            this.failWithMessage(diff.structureDifferences());
        }
        return this;
    }

    public JsonAssert hasSameStructureAs(Object expected) {
        return this.hasSameStructureAs(JsonUtils.convertToJson((Object)expected, (String)EXPECTED));
    }

    public JsonAssert node(String path) {
        return new JsonAssert(this.actual, path, this.description, this.ignorePlaceholder);
    }

    private void failWithMessage(String message) {
        if (this.description != null && this.description.length() > 0) {
            throw new AssertionError((Object)("[" + this.description + "] " + message));
        }
        throw new AssertionError((Object)message);
    }

    public JsonAssert as(String description) {
        return this.describedAs(description);
    }

    public JsonAssert describedAs(String description) {
        return new JsonAssert(this.actual, this.path, description, this.ignorePlaceholder);
    }

    public JsonAssert ignoring(String ignorePlaceholder) {
        return new JsonAssert(this.actual, this.path, this.description, ignorePlaceholder);
    }
}

