/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal.matchers;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.ConfigurationWhen;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonSource;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Path;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class InternalMatcher {
    public static final String ACTUAL = "actual";
    private final Path path;
    private final Object actual;
    private final String description;
    private final Configuration configuration;
    private final String nodeDescription;

    public InternalMatcher(@Nullable Object actual, @NonNull Path path, @NonNull String description, @NonNull Configuration configuration, @NonNull String nodeDescription) {
        this.path = path;
        this.actual = actual;
        this.description = description;
        this.configuration = configuration;
        this.nodeDescription = nodeDescription;
    }

    public InternalMatcher(@Nullable Object actual, @NonNull Path path, @NonNull String description, @NonNull Configuration configuration) {
        this(actual, path, description, configuration, "Node \"" + String.valueOf(path) + "\"");
    }

    public @NonNull InternalMatcher whenIgnoringPaths(String ... pathsToBeIgnored) {
        return new InternalMatcher(this.actual, this.path, this.description, this.configuration.whenIgnoringPaths(pathsToBeIgnored));
    }

    public @NonNull InternalMatcher describedAs(@NonNull String description) {
        return new InternalMatcher(this.actual, this.path, description, this.configuration);
    }

    public @NonNull InternalMatcher withIgnorePlaceholder(@NonNull String ignorePlaceholder) {
        return new InternalMatcher(this.actual, this.path, this.description, this.configuration.withIgnorePlaceholder(ignorePlaceholder));
    }

    public @NonNull InternalMatcher withTolerance(double tolerance) {
        return this.withTolerance(BigDecimal.valueOf(tolerance));
    }

    public @NonNull InternalMatcher withTolerance(@Nullable BigDecimal tolerance) {
        return new InternalMatcher(this.actual, this.path, this.description, this.configuration.withTolerance(tolerance));
    }

    public @NonNull InternalMatcher withMatcher(@NonNull String matcherName, @NonNull Matcher<?> matcher) {
        return new InternalMatcher(this.actual, this.path, this.description, this.configuration.withMatcher(matcherName, matcher));
    }

    public @NonNull InternalMatcher withDifferenceListener(@NonNull DifferenceListener differenceListener) {
        return new InternalMatcher(this.actual, this.path, this.description, this.configuration.withDifferenceListener(differenceListener));
    }

    public @NonNull InternalMatcher withOptions(@NonNull Option firstOption, Option ... otherOptions) {
        return new InternalMatcher(this.actual, this.path, this.description, this.configuration.withOptions(firstOption, otherOptions));
    }

    public final @NonNull InternalMatcher when(@NonNull ConfigurationWhen.PathsParam object, ConfigurationWhen.ApplicableForPath ... actions) {
        return new InternalMatcher(this.actual, this.path, this.description, this.configuration.when(object, actions));
    }

    public void isEqualTo(@Nullable Object expected) {
        Diff diff = this.createDiff(expected, this.configuration);
        diff.failIfDifferent(this.description);
    }

    public void isStringEqualTo(@Nullable String expected) {
        this.isString();
        Node node = this.getActualNode();
        if (!node.asText().equals(expected)) {
            this.failOnDifference(Diff.quoteTextValue(expected), Diff.quoteTextValue(node.asText()));
        }
    }

    private void failOnDifference(@Nullable Object expected, @NonNull Object actual) {
        this.failOnDifference(expected, actual, Collections.singletonList(this.path.toString()));
    }

    private void failOnDifference(@Nullable Object expected, @NonNull Object actual, @NonNull List<String> paths) {
        String node;
        String path;
        if (paths.size() == 1) {
            path = paths.get(0);
            node = "node";
        } else {
            path = paths.toString();
            node = "nodes";
        }
        this.failWithMessage(String.format("Different value found in %s \"%s\", expected: <%s> but was: <%s>.", node, path, expected, actual));
    }

    public void isNotEqualTo(@Nullable Object expected) {
        Diff diff = this.createDiff(expected, this.configuration);
        if (diff.similar()) {
            this.failWithMessage("JSON is equal.");
        }
    }

    public @NonNull InternalMatcher node(@NonNull String newPath) {
        return new InternalMatcher(this.actual, this.path.copy(newPath), this.description, this.configuration);
    }

    private @NonNull Diff createDiff(@Nullable Object expected, @NonNull Configuration configuration) {
        return Diff.create(expected, this.actual, ACTUAL, this.path, configuration);
    }

    private void failWithMessage(@NonNull String message) {
        if (this.description != null && this.description.length() > 0) {
            throw new AssertionError((Object)("[" + this.description + "] " + message));
        }
        throw new AssertionError((Object)message);
    }

    public void isAbsent() {
        if (!JsonUtils.nodeAbsent(this.actual, this.path, this.configuration)) {
            List<String> matchingPaths = this.getMatchingPaths();
            this.failOnDifference("node to be absent", Diff.quoteTextValue(this.getActualNode()), matchingPaths);
        }
    }

    private List<String> getMatchingPaths() {
        JsonSource jsonSource;
        Object object = this.actual;
        if (object instanceof JsonSource && !(jsonSource = (JsonSource)object).getMatchingPaths().isEmpty()) {
            return jsonSource.getMatchingPaths();
        }
        return Collections.singletonList(this.path.toString());
    }

    public void isPresent() {
        this.isPresent("node to be present");
    }

    public void isPresent(@Nullable String expectedValue) {
        if (JsonUtils.nodeAbsent(this.actual, this.path, this.configuration)) {
            this.failOnDifference(expectedValue, "missing");
        }
    }

    public @NonNull ArrayMatcher isArray() {
        Node node = this.assertType(Node.NodeType.ARRAY);
        return new ArrayMatcher(node.arrayElements());
    }

    public @NonNull Node assertType(@NonNull Node.NodeType type) {
        this.isPresent(type.getDescription());
        Node node = this.getActualNode();
        if (node.getNodeType() != type) {
            this.failOnType(node, type);
        }
        return node;
    }

    public @NonNull Node assertIntegralNumber() {
        Node node = this.assertType(Node.NodeType.NUMBER);
        if (!node.isIntegralNumber()) {
            this.failOnType(node, "integer");
        }
        return node;
    }

    public void isObject() {
        this.assertType(Node.NodeType.OBJECT);
    }

    public void isString() {
        this.assertType(Node.NodeType.STRING);
    }

    public void isNull() {
        this.isPresent();
        Node node = this.getActualNode();
        if (node.getNodeType() != Node.NodeType.NULL) {
            this.failOnType(node, "a null");
        }
    }

    public void isNotNull() {
        this.isPresent("not null");
        Node node = this.getActualNode();
        if (node.getNodeType() == Node.NodeType.NULL) {
            this.failOnType(node, "not null");
        }
    }

    public Node getActualNode() {
        return JsonUtils.getNode(this.actual, this.path);
    }

    private void failOnType(@NonNull Node node, @NonNull Node.NodeType expectedType) {
        this.failOnType(node, expectedType.getDescription());
    }

    public void failOnType(@NonNull Node node, @NonNull String expectedType) {
        this.failOnType(expectedType, Diff.quoteTextValue(node.getValue()));
    }

    private void failOnType(@NonNull String expectedType, @Nullable Object actualType) {
        this.failWithMessage(this.nodeDescription + " has invalid type, expected: <" + expectedType + "> but was: <" + String.valueOf(actualType) + ">.");
    }

    public void matches(@NonNull Matcher<?> matcher) {
        this.isPresent();
        this.match(this.actual, this.path, matcher);
    }

    private void match(@NonNull Object value, @NonNull Path path, @NonNull Matcher<?> matcher) {
        Node node = JsonUtils.getNode(value, path);
        MatcherAssert.assertThat((String)(this.nodeDescription + " does not match."), (Object)node.getValue(), matcher);
    }

    public class ArrayMatcher {
        private final List<Node> array;

        ArrayMatcher(Iterator<Node> array) {
            ArrayList<Node> list = new ArrayList<Node>();
            while (array.hasNext()) {
                list.add(array.next());
            }
            this.array = list;
        }

        public void ofLength(int expectedLength) {
            if (this.array.size() != expectedLength) {
                InternalMatcher.this.failWithMessage(InternalMatcher.this.nodeDescription + " has invalid length, expected: <" + expectedLength + "> but was: <" + this.array.size() + ">.");
            }
        }

        public void thatContains(@Nullable Object expected) {
            for (Node node : this.array) {
                Diff diff = Diff.create(expected, (Object)node, InternalMatcher.ACTUAL, "", InternalMatcher.this.configuration);
                if (!diff.similar()) continue;
                return;
            }
            InternalMatcher.this.failWithMessage(InternalMatcher.this.nodeDescription + " is '" + String.valueOf(this.array) + "', expected to contain '" + String.valueOf(expected) + "'.");
        }

        public void isEmpty() {
            if (!this.array.isEmpty()) {
                InternalMatcher.this.failWithMessage(InternalMatcher.this.nodeDescription + " is not an empty array.");
            }
        }

        public void isNotEmpty() {
            if (this.array.isEmpty()) {
                InternalMatcher.this.failWithMessage(InternalMatcher.this.nodeDescription + " is an empty array.");
            }
        }
    }
}

