/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.PathOption;
import org.jspecify.annotations.NonNull;

public class ConfigurationWhen {
    private ConfigurationWhen() {
    }

    public static PathsParam path(String path) {
        return new PathsParam(path);
    }

    public static PathsParam paths(String ... paths) {
        return new PathsParam(paths);
    }

    public static PathsParam rootPath() {
        return ConfigurationWhen.path("");
    }

    public static ApplicableForPath then(Option first, Option ... next) {
        return new OptionsParam(true, first, next);
    }

    public static ApplicableForPath thenNot(Option first, Option ... next) {
        return new OptionsParam(false, first, next);
    }

    public static ApplicableForPath thenIgnore() {
        return new IgnoredParam();
    }

    public static class PathsParam {
        private final List<String> paths;

        private PathsParam(String path) {
            this.paths = Collections.singletonList(path);
        }

        private PathsParam(String ... paths) {
            this.paths = Arrays.asList(paths);
        }

        List<String> getPaths() {
            return this.paths;
        }

        Configuration apply(Configuration configuration, ApplicableForPath action) {
            return action.applyForPaths(configuration, this);
        }
    }

    static class OptionsParam
    implements ApplicableForPath {
        private final EnumSet<Option> options;
        private final boolean included;

        private OptionsParam(boolean included, Option first, Option ... next) {
            this.options = EnumSet.of(first, next);
            this.included = included;
        }

        @Override
        public @NonNull Configuration applyForPaths(@NonNull Configuration configuration, @NonNull PathsParam pathsParam) {
            return configuration.addPathOption(new PathOption(pathsParam.getPaths(), this.options, this.included));
        }
    }

    static class IgnoredParam
    implements ApplicableForPath {
        private IgnoredParam() {
        }

        @Override
        public @NonNull Configuration applyForPaths(@NonNull Configuration configuration, @NonNull PathsParam pathsParam) {
            HashSet<String> ignoredPaths = new HashSet<String>(configuration.getPathsToBeIgnored());
            ignoredPaths.addAll(pathsParam.paths);
            return configuration.whenIgnoringPaths(ignoredPaths);
        }
    }

    public static interface ApplicableForPath {
        public @NonNull Configuration applyForPaths(@NonNull Configuration var1, @NonNull PathsParam var2);
    }
}

