/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParsingException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import net.javacrumbs.jsonunit.core.internal.AbstractNode;
import net.javacrumbs.jsonunit.core.internal.AbstractNodeFactory;
import net.javacrumbs.jsonunit.core.internal.ArrayUtils;
import net.javacrumbs.jsonunit.core.internal.Node;
import org.apache.johnzon.core.JsonLongImpl;
import org.apache.johnzon.mapper.Mapper;
import org.apache.johnzon.mapper.MapperBuilder;

class JohnzonNodeFactory
extends AbstractNodeFactory {
    private final Mapper mapper = new MapperBuilder().build();

    JohnzonNodeFactory() {
    }

    @Override
    protected Node doConvertValue(Object source) {
        if (source instanceof JsonValue) {
            return JohnzonNodeFactory.newNode((JsonValue)source);
        }
        if (source instanceof int[]) {
            return this.newNodeFrom(ArrayUtils.toIntList((int[])source));
        }
        if (source instanceof double[]) {
            return this.newNodeFrom(ArrayUtils.toDoubleList((double[])source));
        }
        if (source instanceof boolean[]) {
            return this.newNodeFrom(ArrayUtils.toBoolList((boolean[])source));
        }
        if (source instanceof Object[]) {
            return this.newNodeFrom(Arrays.asList((Object[])source));
        }
        return this.newNodeFrom(source);
    }

    private Node newNodeFrom(Object source) {
        return JohnzonNodeFactory.newNode(this.mapper.toStructure(source));
    }

    @Override
    protected Node nullNode() {
        return JohnzonNodeFactory.newNode(JsonValue.NULL);
    }

    @Override
    protected Node readValue(Reader reader, String label, boolean lenient) {
        JsonReader parser = Json.createReader((Reader)reader);
        try {
            Node node = JohnzonNodeFactory.newNode(parser.readValue());
            return node;
        }
        catch (JsonParsingException e) {
            throw this.newParseException(label, reader, (Exception)((Object)e));
        }
        finally {
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @Override
    public boolean isPreferredFor(Object source) {
        return source instanceof JsonValue;
    }

    private static Node newNode(JsonValue value) {
        return new JavaxJsonNode(value);
    }

    static final class JavaxJsonNode
    extends AbstractNode {
        private final JsonValue jsonNode;

        JavaxJsonNode(JsonValue jsonNode) {
            this.jsonNode = jsonNode;
        }

        @Override
        public Node element(int index) {
            if (this.jsonNode instanceof JsonArray) {
                try {
                    return JohnzonNodeFactory.newNode((JsonValue)((JsonArray)this.jsonNode).get(index));
                }
                catch (IndexOutOfBoundsException e) {
                    return MISSING_NODE;
                }
            }
            return MISSING_NODE;
        }

        @Override
        public Iterator<Node.KeyValue> fields() {
            if (this.jsonNode instanceof JsonObject) {
                final Iterator iterator = ((JsonObject)this.jsonNode).entrySet().iterator();
                return new Iterator<Node.KeyValue>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }

                    @Override
                    public Node.KeyValue next() {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        return new Node.KeyValue((String)entry.getKey(), JohnzonNodeFactory.newNode((JsonValue)entry.getValue()));
                    }
                };
            }
            throw new IllegalStateException("Can call fields() only on an JsonObject");
        }

        @Override
        public Node get(String key) {
            if (this.isObject()) {
                JsonObject jsonObject = (JsonObject)this.jsonNode;
                if (jsonObject.containsKey((Object)key)) {
                    return JohnzonNodeFactory.newNode((JsonValue)jsonObject.get((Object)key));
                }
                return Node.MISSING_NODE;
            }
            return Node.MISSING_NODE;
        }

        @Override
        public boolean isMissingNode() {
            return false;
        }

        @Override
        public boolean isNull() {
            return this.jsonNode.equals(JsonValue.NULL);
        }

        @Override
        public boolean isObject() {
            return this.jsonNode instanceof JsonObject;
        }

        @Override
        public Iterator<Node> arrayElements() {
            if (this.jsonNode instanceof JsonArray) {
                final Iterator iterator = ((JsonArray)this.jsonNode).iterator();
                return new Iterator<Node>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }

                    @Override
                    public Node next() {
                        return JohnzonNodeFactory.newNode((JsonValue)iterator.next());
                    }
                };
            }
            throw new IllegalStateException("Can call arrayElements() only on an JsonArray");
        }

        @Override
        public int size() {
            if (this.jsonNode instanceof JsonArray) {
                return ((JsonArray)this.jsonNode).size();
            }
            throw new IllegalStateException("Can call size() only on an JsonArray");
        }

        @Override
        public Node.NodeType getNodeType() {
            return switch (this.jsonNode.getValueType()) {
                default -> throw new IncompatibleClassChangeError();
                case JsonValue.ValueType.OBJECT -> Node.NodeType.OBJECT;
                case JsonValue.ValueType.ARRAY -> Node.NodeType.ARRAY;
                case JsonValue.ValueType.STRING -> Node.NodeType.STRING;
                case JsonValue.ValueType.NUMBER -> Node.NodeType.NUMBER;
                case JsonValue.ValueType.TRUE, JsonValue.ValueType.FALSE -> Node.NodeType.BOOLEAN;
                case JsonValue.ValueType.NULL -> Node.NodeType.NULL;
            };
        }

        @Override
        public String asText() {
            if (this.jsonNode.getValueType() == JsonValue.ValueType.STRING) {
                return ((JsonString)this.jsonNode).getString();
            }
            throw new IllegalStateException("Not a JsonString: " + this.jsonNode);
        }

        @Override
        public BigDecimal decimalValue() {
            if (this.isNumber()) {
                return ((JsonNumber)this.jsonNode).bigDecimalValue();
            }
            throw new IllegalStateException("Not a JsonNumber: " + this.jsonNode);
        }

        @Override
        public boolean isIntegralNumber() {
            return this.jsonNode instanceof JsonLongImpl;
        }

        private boolean isNumber() {
            return this.jsonNode.getValueType() == JsonValue.ValueType.NUMBER;
        }

        @Override
        public Boolean asBoolean() {
            if (this.jsonNode.getValueType() == JsonValue.ValueType.TRUE) {
                return true;
            }
            if (this.jsonNode.getValueType() == JsonValue.ValueType.FALSE) {
                return false;
            }
            throw new IllegalStateException("Not a JsonBoolean: " + this.jsonNode);
        }

        public String toString() {
            return this.jsonNode.toString();
        }
    }
}

