/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import net.javacrumbs.jsonunit.core.Option;

class Options {
    private static final Options EMPTY_OPTIONS = new Options(EnumSet.noneOf(Option.class));
    private final EnumSet<Option> options;

    private Options(EnumSet<Option> options) {
        this.options = options;
    }

    public static Options empty() {
        return EMPTY_OPTIONS;
    }

    public boolean contains(Option option) {
        return this.options.contains((Object)option);
    }

    public Options with(Option option, Option ... otherOptions) {
        EnumSet<Option> optionsWith = EnumSet.copyOf(this.options);
        optionsWith.addAll(EnumSet.of(option, otherOptions));
        return new Options(optionsWith);
    }

    public Options with(Collection<Option> options) {
        EnumSet<Option> optionsWith = EnumSet.copyOf(options);
        optionsWith.addAll(options);
        return new Options(optionsWith);
    }

    public Set<Option> values() {
        return EnumSet.copyOf(this.options);
    }
}

