/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUnitLogger;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Path;

class ComparisonMatrix {
    private final List<List<Integer>> equalElements;
    private final int compareFrom;
    private final Integer[] matches;
    private final List<Integer> extra;
    private final BitSet alreadyMatched;
    private final List<Node> expectedElements;
    private final List<Node> actualElements;

    private ComparisonMatrix(List<List<Integer>> equalElements, int compareFrom, Integer[] matches, List<Integer> extra, BitSet alreadyMatched, List<Node> expectedElements, List<Node> actualElements) {
        this.equalElements = equalElements;
        this.compareFrom = compareFrom;
        this.matches = matches;
        this.extra = extra;
        this.alreadyMatched = alreadyMatched;
        this.expectedElements = expectedElements;
        this.actualElements = actualElements;
    }

    ComparisonMatrix(List<Node> expectedElements, List<Node> actualElements, Path path, Configuration configuration) {
        this(ComparisonMatrix.generateEqualElements(expectedElements, actualElements, path, configuration), 0, new Integer[expectedElements.size()], new ArrayList<Integer>(), new BitSet(), expectedElements, actualElements);
    }

    private static List<List<Integer>> generateEqualElements(List<Node> expectedElements, List<Node> actualElements, Path path, Configuration configuration) {
        ArrayList<List<Integer>> equalElements = new ArrayList<List<Integer>>(actualElements.size());
        for (int i = 0; i < actualElements.size(); ++i) {
            Node actual = actualElements.get(i);
            ArrayList<Integer> actualIsEqualTo = new ArrayList<Integer>(expectedElements.size());
            for (int j = 0; j < expectedElements.size(); ++j) {
                Node expected = expectedElements.get(j);
                Diff diff = new Diff(expected, actual, Path.create("", path.toElement(i).getFullPath()), configuration.withDifferenceListener(Configuration.dummyDifferenceListener()), JsonUnitLogger.NULL_LOGGER, JsonUnitLogger.NULL_LOGGER, "expected: <%s> but was: <%s>");
                if (!diff.similar()) continue;
                actualIsEqualTo.add(j);
            }
            equalElements.add(Collections.unmodifiableList(actualIsEqualTo));
        }
        return equalElements;
    }

    ComparisonMatrix compare() {
        this.doSimpleMatching();
        for (int i = this.compareFrom; i < this.equalElements.size(); ++i) {
            if (this.alreadyMatched.get(i)) continue;
            List<Integer> matches = this.getEqualValues(i);
            if (matches.size() == 1) {
                this.recordMatch(i, matches.get(0));
                continue;
            }
            if (matches.size() > 0) {
                for (int match : matches) {
                    ComparisonMatrix copy = this.copy(i + 1);
                    copy.recordMatch(i, match);
                    if (!(copy = copy.compare()).isMatching()) continue;
                    return copy;
                }
                this.recordMatch(i, matches.get(0));
                continue;
            }
            this.addExtra(i);
        }
        return this;
    }

    private void doSimpleMatching() {
        for (int i = 0; i < this.equalElements.size(); ++i) {
            List<Integer> equalTo;
            if (this.alreadyMatched.get(i) || (equalTo = this.equalElements.get(i)).size() <= 0) continue;
            List<Integer> equivalentElements = this.getEquivalentElements(equalTo);
            if (equalTo.size() == equivalentElements.size()) {
                for (int j = 0; j < equivalentElements.size(); ++j) {
                    this.recordMatch(equivalentElements.get(j), equalTo.get(j));
                }
                continue;
            }
            if (equivalentElements.size() <= 1 || equalTo.size() <= 1) continue;
            List<Integer> equalToUsedOnlyInEquivalentElements = this.getEqualToUsedOnlyInEquivalentElements(equalTo, equivalentElements);
            for (int j = 0; j < Math.min(equivalentElements.size(), equalToUsedOnlyInEquivalentElements.size()); ++j) {
                this.recordMatch(equivalentElements.get(j), equalTo.get(j));
            }
        }
    }

    private List<Integer> getEqualToUsedOnlyInEquivalentElements(List<Integer> equalTo, List<Integer> equivalentElements) {
        ArrayList<Integer> result = new ArrayList<Integer>(equalTo);
        for (int i = 0; i < this.equalElements.size(); ++i) {
            if (this.alreadyMatched.get(i) || equivalentElements.contains(i)) continue;
            result.removeAll((Collection)this.equalElements.get(i));
        }
        return result;
    }

    private List<Integer> getEquivalentElements(List<Integer> equalTo) {
        ArrayList<Integer> equivalentElments = new ArrayList<Integer>();
        for (int i = 0; i < this.equalElements.size(); ++i) {
            if (this.alreadyMatched.get(i) || !equalTo.equals(this.equalElements.get(i))) continue;
            equivalentElments.add(i);
        }
        return equivalentElments;
    }

    private void addExtra(int index) {
        this.extra.add(index);
    }

    private List<Integer> getEqualValues(int actualIndex) {
        return this.equalElements.get(actualIndex);
    }

    ComparisonMatrix copy(int compareFrom) {
        return new ComparisonMatrix(new ArrayList<List<Integer>>(this.equalElements), compareFrom, (Integer[])this.matches.clone(), new ArrayList<Integer>(this.extra), (BitSet)this.alreadyMatched.clone(), this.expectedElements, this.actualElements);
    }

    private void recordMatch(int actualIndex, int expectedIndex) {
        this.matches[expectedIndex] = actualIndex;
        for (int i = 0; i < this.equalElements.size(); ++i) {
            if (this.alreadyMatched.get(i)) continue;
            this.equalElements.set(i, this.equalElements.get(i).stream().filter(n -> n != expectedIndex).collect(Collectors.toList()));
        }
        this.alreadyMatched.set(actualIndex);
    }

    private boolean isMatching() {
        return this.extra.isEmpty() && this.getMissing().isEmpty();
    }

    List<Integer> getMissing() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < this.matches.length; ++i) {
            if (this.matches[i] != null) continue;
            result.add(i);
        }
        return result;
    }

    List<Integer> getExtra() {
        return this.extra;
    }
}

