/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import net.javacrumbs.jsonunit.core.internal.GenericNodeBuilder;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.NodeFactory;

abstract class AbstractNodeFactory
implements NodeFactory {
    AbstractNodeFactory() {
    }

    @Override
    public Node convertToNode(Object source, String label, boolean lenient) {
        if (source == null) {
            return this.nullNode();
        }
        if (source instanceof Node) {
            return (Node)source;
        }
        if (source instanceof String && ((String)source).trim().length() > 0) {
            return this.readValue((String)source, label, lenient);
        }
        if (source instanceof Reader) {
            return this.readValue((Reader)source, label, lenient);
        }
        return this.convertValue(source);
    }

    @Override
    public Node valueToNode(Object source) {
        if (source == null) {
            return this.nullNode();
        }
        return this.convertValue(source);
    }

    final Node convertValue(Object source) {
        if (source instanceof BigDecimal) {
            return new GenericNodeBuilder.NumberNode((Number)source);
        }
        return this.doConvertValue(source);
    }

    protected abstract Node doConvertValue(Object var1);

    protected abstract Node readValue(Reader var1, String var2, boolean var3);

    protected Node readValue(String source, String label, boolean lenient) {
        return this.readValue(new StringReader(source), label, lenient);
    }

    protected abstract Node nullNode();
}

