/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Converter;
import net.javacrumbs.jsonunit.core.internal.GenericNodeBuilder;
import net.javacrumbs.jsonunit.core.internal.JsonSource;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Path;

public class JsonUtils {
    private static final Converter converter = Converter.createDefaultConverter();

    public static Node convertToJson(Object source, String label) {
        return JsonUtils.convertToJson(source, label, false);
    }

    public static Node convertToJson(Object source, String label, boolean lenient) {
        if (source instanceof JsonSource) {
            return converter.convertToNode(((JsonSource)source).getJson(), label, lenient);
        }
        return converter.convertToNode(source, label, lenient);
    }

    public static Node valueToNode(Object source) {
        if (source instanceof Node) {
            return (Node)source;
        }
        return converter.valueToNode(source);
    }

    public static Node getNode(Object root, String path) {
        return JsonUtils.getNode(root, Path.create(path));
    }

    public static Node getNode(Object root, Path path) {
        return path.getNode(JsonUtils.convertToJson(root, "actual"));
    }

    @Deprecated
    public static boolean nodeExists(Object json, String path) {
        return !JsonUtils.getNode(json, path).isMissingNode();
    }

    public static boolean nodeAbsent(Object json, String path, Configuration configuration) {
        return JsonUtils.nodeAbsent(json, Path.create(path), configuration);
    }

    public static boolean nodeAbsent(Object json, Path path, Configuration configuration) {
        return JsonUtils.nodeAbsent(json, path, configuration.getOptions().contains(Option.TREATING_NULL_AS_ABSENT));
    }

    public static Object jsonSource(final Object json, final String pathPrefix) {
        return new JsonSource(){

            @Override
            public Object getJson() {
                return json;
            }

            @Override
            public String getPathPrefix() {
                return pathPrefix;
            }
        };
    }

    public static String getPathPrefix(Object json) {
        if (json instanceof JsonSource) {
            return ((JsonSource)json).getPathPrefix();
        }
        return "";
    }

    static boolean nodeAbsent(Object json, Path path, boolean treatNullAsAbsent) {
        Node node = JsonUtils.getNode(json, path);
        if (node.isNull()) {
            return treatNullAsAbsent;
        }
        return node.isMissingNode();
    }

    static String quoteIfNeeded(String source) {
        String trimmed = source.trim();
        if (JsonUtils.isObject(trimmed) || JsonUtils.isArray(trimmed) || JsonUtils.isString(trimmed) || JsonUtils.isBoolean(trimmed) || JsonUtils.isNull(trimmed) || JsonUtils.isNumber(trimmed)) {
            return source;
        }
        return "\"" + source + "\"";
    }

    static Object quoteIfNeeded(Object source) {
        if (source instanceof String) {
            return JsonUtils.quoteIfNeeded((String)source);
        }
        return source;
    }

    public static Node wrapDeserializedObject(Object source) {
        return GenericNodeBuilder.wrapDeserializedObject(source);
    }

    private static boolean isNull(String trimmed) {
        return trimmed.equals("null");
    }

    private static boolean isBoolean(String trimmed) {
        return trimmed.equals("true") || trimmed.equals("false");
    }

    private static boolean isString(String trimmed) {
        return trimmed.startsWith("\"");
    }

    private static boolean isArray(String trimmed) {
        return trimmed.startsWith("[");
    }

    private static boolean isObject(String trimmed) {
        return trimmed.startsWith("{");
    }

    private static boolean isNumber(String source) {
        try {
            Double.parseDouble(source);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

