/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.javacrumbs.jsonunit.core.internal.Converter;
import net.javacrumbs.jsonunit.core.internal.Node;

public class JsonUtils {
    private static final Pattern arrayPattern = Pattern.compile("(\\w*)\\[(\\d+)\\]");
    private static final Converter converter = Converter.createDefaultConverter();

    public static Node convertToJson(Object source, String label) {
        return converter.convertToNode(source, label);
    }

    static Node getNode(Node root, String path) {
        if (path.length() == 0) {
            return root;
        }
        Node startNode = root;
        StringTokenizer stringTokenizer = new StringTokenizer(path, ".");
        while (stringTokenizer.hasMoreElements()) {
            String step = stringTokenizer.nextToken();
            Matcher matcher = arrayPattern.matcher(step);
            if (!matcher.matches()) {
                startNode = startNode.get(step);
                continue;
            }
            if (matcher.group(1).length() != 0) {
                startNode = startNode.get(matcher.group(1));
            }
            startNode = startNode.element(Integer.valueOf(matcher.group(2)));
        }
        return startNode;
    }

    public static Node getNode(Object root, String path) {
        return JsonUtils.getNode(JsonUtils.convertToJson(root, "actual"), path);
    }

    public static boolean nodeExists(Object json, String path) {
        return !JsonUtils.getNode(json, path).isMissingNode();
    }

    static String quoteIfNeeded(String source) {
        String trimmed = source.trim();
        if (JsonUtils.isObject(trimmed) || JsonUtils.isArray(trimmed) || JsonUtils.isString(trimmed) || JsonUtils.isBoolean(trimmed) || JsonUtils.isNull(trimmed) || JsonUtils.isNumber(trimmed)) {
            return source;
        }
        return "\"" + source + "\"";
    }

    static Object quoteIfNeeded(Object source) {
        if (source instanceof String) {
            return JsonUtils.quoteIfNeeded((String)source);
        }
        return source;
    }

    private static boolean isNull(String trimmed) {
        return trimmed.equals("null");
    }

    private static boolean isBoolean(String trimmed) {
        return trimmed.equals("true") || trimmed.equals("false");
    }

    private static boolean isString(String trimmed) {
        return trimmed.startsWith("\"");
    }

    private static boolean isArray(String trimmed) {
        return trimmed.startsWith("[");
    }

    private static boolean isObject(String trimmed) {
        return trimmed.startsWith("{");
    }

    private static boolean isNumber(String source) {
        try {
            Double.parseDouble(source);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

