/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.util.ArrayList;
import java.util.List;
import net.javacrumbs.jsonunit.core.internal.ClassUtils;
import net.javacrumbs.jsonunit.core.internal.GsonNodeFactory;
import net.javacrumbs.jsonunit.core.internal.Jackson1NodeFactory;
import net.javacrumbs.jsonunit.core.internal.Jackson2NodeFactory;
import net.javacrumbs.jsonunit.core.internal.JsonOrgNodeFactory;
import net.javacrumbs.jsonunit.core.internal.MoshiNodeFactory;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.NodeFactory;

class Converter {
    static final String LIBRARIES_PROPERTY_NAME = "json-unit.libraries";
    private final List<NodeFactory> factories;
    private static final boolean jackson1Present = ClassUtils.isClassPresent("org.codehaus.jackson.map.ObjectMapper") && ClassUtils.isClassPresent("org.codehaus.jackson.JsonGenerator");
    private static final boolean jackson2Present = ClassUtils.isClassPresent("com.fasterxml.jackson.databind.ObjectMapper") && ClassUtils.isClassPresent("com.fasterxml.jackson.core.JsonGenerator");
    private static final boolean gsonPresent = ClassUtils.isClassPresent("com.google.gson.Gson");
    private static final boolean jsonOrgPresent = ClassUtils.isClassPresent("org.json.JSONObject");
    private static final boolean moshiPresent = ClassUtils.isClassPresent("com.squareup.moshi.Moshi");

    Converter(List<NodeFactory> factories) {
        if (factories.isEmpty()) {
            throw new IllegalStateException("List of factories can not be empty");
        }
        this.factories = factories;
    }

    static Converter createDefaultConverter() {
        String property = System.getProperty(LIBRARIES_PROPERTY_NAME);
        List<NodeFactory> factories = property != null && property.trim().length() > 0 ? Converter.createFactoriesSpecifiedInProperty(property) : Converter.createDefaultFactories();
        if (factories.isEmpty()) {
            throw new IllegalStateException("Please add either json.org, Jackson 1.x, Jackson 2.x or Gson to the classpath");
        }
        return new Converter(factories);
    }

    private static List<NodeFactory> createFactoriesSpecifiedInProperty(String property) {
        ArrayList<NodeFactory> factories = new ArrayList<NodeFactory>();
        for (String factoryName : property.toLowerCase().split(",")) {
            if ("moshi".equals(factoryName = factoryName.trim())) {
                factories.add(new MoshiNodeFactory());
                continue;
            }
            if ("json.org".equals(factoryName)) {
                factories.add(new JsonOrgNodeFactory());
                continue;
            }
            if ("jackson1".equals(factoryName)) {
                factories.add(new Jackson1NodeFactory());
                continue;
            }
            if ("jackson2".equals(factoryName)) {
                factories.add(new Jackson2NodeFactory());
                continue;
            }
            if ("gson".equals(factoryName)) {
                factories.add(new GsonNodeFactory());
                continue;
            }
            throw new IllegalArgumentException("'" + factoryName + "' library name not recognized.");
        }
        return factories;
    }

    private static List<NodeFactory> createDefaultFactories() {
        ArrayList<NodeFactory> factories = new ArrayList<NodeFactory>();
        if (moshiPresent) {
            factories.add(new MoshiNodeFactory());
        }
        if (jsonOrgPresent) {
            factories.add(new JsonOrgNodeFactory());
        }
        if (jackson1Present) {
            factories.add(new Jackson1NodeFactory());
        }
        if (gsonPresent) {
            factories.add(new GsonNodeFactory());
        }
        if (jackson2Present) {
            factories.add(new Jackson2NodeFactory());
        }
        return factories;
    }

    Node convertToNode(Object source, String label, boolean lenient) {
        for (int i = 0; i < this.factories.size(); ++i) {
            NodeFactory factory = this.factories.get(i);
            if (!this.isLastFactory(i) && !factory.isPreferredFor(source)) continue;
            return factory.convertToNode(source, label, lenient);
        }
        throw new IllegalStateException("Should not happen");
    }

    private boolean isLastFactory(int i) {
        return this.factories.size() - 1 == i;
    }

    List<NodeFactory> getFactories() {
        return this.factories;
    }
}

