/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.io.Reader;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.javacrumbs.jsonunit.core.internal.AbstractNodeFactory;
import net.javacrumbs.jsonunit.core.internal.GenericNodeBuilder;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Utils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

class JsonOrgNodeFactory
extends AbstractNodeFactory {
    JsonOrgNodeFactory() {
    }

    @Override
    protected Node convertValue(Object source) {
        return JsonOrgNodeFactory.newNode(source);
    }

    @Override
    protected Node nullNode() {
        return JsonOrgNodeFactory.newNode(null);
    }

    @Override
    protected Node readValue(Reader value, String label, boolean lenient) {
        try {
            Node node = JsonOrgNodeFactory.newNode(new JSONTokener(value).nextValue());
            return node;
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Can not parse " + label + " value.", e);
        }
        finally {
            Utils.closeQuietly(value);
        }
    }

    private static Node newNode(Object object) {
        if (object instanceof JSONObject) {
            return new JSONObjectNode((JSONObject)object);
        }
        if (object instanceof Number) {
            return new GenericNodeBuilder.NumberNode((Number)object);
        }
        if (object instanceof String) {
            return new GenericNodeBuilder.StringNode((String)object);
        }
        if (object instanceof Boolean) {
            return new GenericNodeBuilder.BooleanNode((Boolean)object);
        }
        if (object instanceof JSONArray) {
            return new JSONArrayNode((JSONArray)object);
        }
        if (JSONObject.NULL.equals(object)) {
            return new GenericNodeBuilder.NullNode();
        }
        if (object instanceof Map) {
            return new JSONObjectNode(new JSONObject((Map)object));
        }
        if (object instanceof Collection || object.getClass().isArray()) {
            return new JSONArrayNode((JSONArray)JSONObject.wrap((Object)object));
        }
        throw new IllegalArgumentException("Unsupported type " + object.getClass());
    }

    @Override
    public boolean isPreferredFor(Object source) {
        return source instanceof JSONObject || source instanceof JSONArray;
    }

    private static final class JSONObjectNode
    extends GenericNodeBuilder.NodeSkeleton {
        private final JSONObject jsonObject;

        private JSONObjectNode(JSONObject jsonObject) {
            this.jsonObject = jsonObject;
        }

        @Override
        public Node element(int index) {
            return JsonOrgNodeFactory.newNode(null);
        }

        @Override
        public Iterator<Node.KeyValue> fields() {
            final Iterator iterator = this.jsonObject.keys();
            return new Iterator<Node.KeyValue>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }

                @Override
                public Node.KeyValue next() {
                    String fieldName = (String)iterator.next();
                    return new Node.KeyValue(fieldName, JsonOrgNodeFactory.newNode(JSONObjectNode.this.jsonObject.get(fieldName)));
                }
            };
        }

        @Override
        public Node get(String key) {
            Object value = this.jsonObject.opt(key);
            if (value != null) {
                return JsonOrgNodeFactory.newNode(value);
            }
            return MISSING_NODE;
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.OBJECT;
        }

        public String toString() {
            return this.jsonObject.toString();
        }
    }

    private static final class JSONArrayNode
    extends GenericNodeBuilder.NodeSkeleton {
        private final JSONArray value;

        private JSONArrayNode(JSONArray value) {
            this.value = value;
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.ARRAY;
        }

        @Override
        public Node element(int index) {
            try {
                return JsonOrgNodeFactory.newNode(this.value.get(index));
            }
            catch (JSONException e) {
                return MISSING_NODE;
            }
        }

        @Override
        public Iterator<Node> arrayElements() {
            final Iterator iterator = this.value.iterator();
            return new Iterator<Node>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Node next() {
                    return JsonOrgNodeFactory.newNode(iterator.next());
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }

        @Override
        public int size() {
            return this.value.length();
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

