/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

interface JsonUnitLogger {
    public boolean isEnabled();

    public void log(String var1, Object ... var2);

    public static final class NullLogger
    implements JsonUnitLogger {
        public boolean isEnabled() {
            return false;
        }

        public void log(String message, Object ... params) {
        }
    }

    public static final class SLF4JLogger
    implements JsonUnitLogger {
        private final Logger logger;

        SLF4JLogger(String name) {
            this.logger = LoggerFactory.getLogger((String)name);
        }

        public boolean isEnabled() {
            return this.logger.isDebugEnabled();
        }

        public void log(String message, Object ... params) {
            this.logger.debug(message, params);
        }
    }
}

