/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core;

import java.math.BigDecimal;
import net.javacrumbs.jsonunit.core.Matchers;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Options;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private static final Configuration EMPTY_CONFIGURATION = new Configuration(null, Options.empty(), "${json-unit.ignore}", Matchers.empty());
    private final BigDecimal tolerance;
    private final Options options;
    private final String ignorePlaceholder;
    private final Matchers matchers;

    @Deprecated
    public Configuration(BigDecimal tolerance, Options options, String ignorePlaceholder) {
        this(tolerance, options, ignorePlaceholder, Matchers.empty());
    }

    private Configuration(BigDecimal tolerance, Options options, String ignorePlaceholder, Matchers matchers) {
        this.tolerance = tolerance;
        this.options = options;
        this.ignorePlaceholder = ignorePlaceholder;
        this.matchers = matchers;
    }

    public static Configuration empty() {
        return EMPTY_CONFIGURATION;
    }

    public Configuration withTolerance(BigDecimal tolerance) {
        return new Configuration(tolerance, this.options, this.ignorePlaceholder, this.matchers);
    }

    public Configuration withTolerance(double tolerance) {
        return this.withTolerance(BigDecimal.valueOf(tolerance));
    }

    public Configuration when(Option first, Option ... next) {
        return this.withOptions(first, next);
    }

    public Configuration withOptions(Option first, Option ... next) {
        return new Configuration(this.tolerance, this.options.with(first, next), this.ignorePlaceholder, this.matchers);
    }

    public Configuration withOptions(Options options) {
        return new Configuration(this.tolerance, options, this.ignorePlaceholder, this.matchers);
    }

    public Configuration withIgnorePlaceholder(String ignorePlaceholder) {
        return new Configuration(this.tolerance, this.options, ignorePlaceholder, this.matchers);
    }

    public Configuration withMatcher(String matcherName, Matcher<?> matcher) {
        return new Configuration(this.tolerance, this.options, this.ignorePlaceholder, this.matchers.with(matcherName, matcher));
    }

    public Matcher<?> getMatcher(String matcherName) {
        return this.matchers.getMatcher(matcherName);
    }

    public BigDecimal getTolerance() {
        return this.tolerance;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getIgnorePlaceholder() {
        return this.ignorePlaceholder;
    }
}

