/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Differences;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Diff {
    private static final String REGEX_PLACEHOLDER = "${json-unit.regex}";
    private final Node expectedRoot;
    private final Node actualRoot;
    private final Differences differences = new Differences();
    private final String startPath;
    private boolean compared = false;
    private final Configuration configuration;
    private static final Logger diffLogger = LoggerFactory.getLogger((String)"net.javacrumbs.jsonunit.difference.diff");
    private static final Logger valuesLogger = LoggerFactory.getLogger((String)"net.javacrumbs.jsonunit.difference.values");

    private Diff(Node expected, Node actual, String startPath, Configuration configuration) {
        this.expectedRoot = expected;
        this.actualRoot = actual;
        this.startPath = startPath;
        this.configuration = configuration;
    }

    public static Diff create(Object expected, Object actual, String actualName, String startPath, Configuration configuration) {
        return new Diff(JsonUtils.convertToJson(JsonUtils.quoteIfNeeded(expected), "expected", true), JsonUtils.convertToJson(actual, actualName, false), startPath, configuration);
    }

    private void compare() {
        if (!this.compared) {
            Node part = JsonUtils.getNode(this.actualRoot, this.startPath);
            if (part.isMissingNode()) {
                this.structureDifferenceFound("Missing node in path \"%s\".", this.startPath);
            } else {
                this.compareNodes(this.expectedRoot, part, this.startPath);
            }
            this.compared = true;
        }
    }

    private void compareObjectNodes(Node expected, Node actual, String path) {
        Set<String> actualKeys;
        Map<String, Node> expectedFields = Diff.getFields(expected);
        Map<String, Node> actualFields = Diff.getFields(actual);
        Set<String> expectedKeys = expectedFields.keySet();
        if (!expectedKeys.equals(actualKeys = actualFields.keySet())) {
            Set<String> missingKeys = Diff.getMissingKeys(expectedKeys, actualKeys);
            Set<String> extraKeys = this.getExtraKeys(expectedKeys, actualKeys);
            if (this.hasOption(Option.TREATING_NULL_AS_ABSENT)) {
                extraKeys = this.getNotNullExtraKeys(actual, extraKeys);
            }
            if (!missingKeys.isEmpty() || !extraKeys.isEmpty()) {
                String missingKeysMessage = Diff.getMissingKeysMessage(missingKeys, path);
                String extraKeysMessage = Diff.getExtraKeysMessage(extraKeys, path);
                this.structureDifferenceFound("Different keys found in node \"%s\". Expected %s, got %s. %s %s", path, this.sort(expectedFields.keySet()), this.sort(actualFields.keySet()), missingKeysMessage, extraKeysMessage);
            }
        }
        for (String fieldName : this.commonFields(expectedFields, actualFields)) {
            Node expectedNode = expectedFields.get(fieldName);
            Node actualNode = actualFields.get(fieldName);
            String fieldPath = Diff.getPath(path, fieldName);
            this.compareNodes(expectedNode, actualNode, fieldPath);
        }
    }

    private Set<String> getNotNullExtraKeys(Node actual, Set<String> extraKeys) {
        TreeSet<String> notNullExtraKeys = new TreeSet<String>();
        for (String extraKey : extraKeys) {
            if (actual.get(extraKey).isNull()) continue;
            notNullExtraKeys.add(extraKey);
        }
        return notNullExtraKeys;
    }

    private static String getMissingKeysMessage(Set<String> missingKeys, String path) {
        if (!missingKeys.isEmpty()) {
            return "Missing: " + Diff.appendKeysToPrefix(missingKeys, path);
        }
        return "";
    }

    private static Set<String> getMissingKeys(Set<String> expectedKeys, Collection<String> actualKeys) {
        TreeSet<String> missingKeys = new TreeSet<String>(expectedKeys);
        missingKeys.removeAll(actualKeys);
        return missingKeys;
    }

    private static String getExtraKeysMessage(Set<String> extraKeys, String path) {
        if (!extraKeys.isEmpty()) {
            return "Extra: " + Diff.appendKeysToPrefix(extraKeys, path);
        }
        return "";
    }

    private Set<String> getExtraKeys(Set<String> expectedKeys, Collection<String> actualKeys) {
        if (!this.hasOption(Option.IGNORING_EXTRA_FIELDS)) {
            TreeSet<String> extraKeys = new TreeSet<String>(actualKeys);
            extraKeys.removeAll(expectedKeys);
            return extraKeys;
        }
        return Collections.emptySet();
    }

    private boolean hasOption(Option option) {
        return this.configuration.getOptions().contains(option);
    }

    private static String appendKeysToPrefix(Iterable<String> keys, String prefix) {
        Iterator<String> iterator = keys.iterator();
        StringBuilder buffer = new StringBuilder();
        while (iterator.hasNext()) {
            String key = iterator.next();
            buffer.append("\"").append(Diff.getPath(prefix, key)).append("\"");
            if (!iterator.hasNext()) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    private void compareNodes(Node expectedNode, Node actualNode, String fieldPath) {
        Node.NodeType expectedNodeType = expectedNode.getNodeType();
        Node.NodeType actualNodeType = actualNode.getNodeType();
        if (expectedNodeType == Node.NodeType.STRING && this.configuration.getIgnorePlaceholder().equals(expectedNode.asText())) {
            return;
        }
        if (this.checkAny(Node.NodeType.NUMBER, "${json-unit.any-number}", "a number", expectedNode, actualNode, fieldPath)) {
            return;
        }
        if (this.checkAny(Node.NodeType.BOOLEAN, "${json-unit.any-boolean}", "a boolean", expectedNode, actualNode, fieldPath)) {
            return;
        }
        if (this.checkAny(Node.NodeType.STRING, "${json-unit.any-string}", "a string", expectedNode, actualNode, fieldPath)) {
            return;
        }
        if (!expectedNodeType.equals(actualNodeType)) {
            this.valueDifferenceFound("Different value found in node \"%s\". Expected '%s', got '%s'.", fieldPath, this.quoteTextValue(expectedNode), this.quoteTextValue(actualNode));
        } else {
            switch (expectedNodeType) {
                case OBJECT: {
                    this.compareObjectNodes(expectedNode, actualNode, fieldPath);
                    break;
                }
                case ARRAY: {
                    this.compareArrayNodes(expectedNode, actualNode, fieldPath);
                    break;
                }
                case STRING: {
                    this.compareStringValues(expectedNode.asText(), actualNode.asText(), fieldPath);
                    break;
                }
                case NUMBER: {
                    BigDecimal actualValue = actualNode.decimalValue();
                    BigDecimal expectedValue = expectedNode.decimalValue();
                    if (this.configuration.getTolerance() != null && !this.hasOption(Option.IGNORING_VALUES)) {
                        BigDecimal diff = expectedValue.subtract(actualValue).abs();
                        if (diff.compareTo(this.configuration.getTolerance()) <= 0) break;
                        this.valueDifferenceFound("Different value found in node \"%s\". Expected %s, got %s, difference is %s, tolerance is %s", fieldPath, this.quoteTextValue(expectedValue), this.quoteTextValue(actualValue), diff.toString(), this.configuration.getTolerance());
                        break;
                    }
                    this.compareValues(expectedValue, actualValue, fieldPath);
                    break;
                }
                case BOOLEAN: {
                    this.compareValues(expectedNode.asBoolean(), actualNode.asBoolean(), fieldPath);
                    break;
                }
                case NULL: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected node type " + expectedNodeType);
                }
            }
        }
    }

    private boolean checkAny(Node.NodeType type, String placeholder, String name, Node expectedNode, Node actualNode, String fieldPath) {
        if (expectedNode.getNodeType() == Node.NodeType.STRING && placeholder.equals(expectedNode.asText())) {
            if (actualNode.getNodeType() == type) {
                return true;
            }
            this.valueDifferenceFound("Different value found in node \"%s\". Expected %s, got '%s'.", fieldPath, name, this.quoteTextValue(actualNode));
            return true;
        }
        return false;
    }

    private void compareStringValues(String expectedValue, String actualValue, String path) {
        if (this.hasOption(Option.IGNORING_VALUES)) {
            return;
        }
        if (this.isRegexExpected(expectedValue)) {
            String pattern = this.getRegexPattern(expectedValue);
            if (!actualValue.matches(pattern)) {
                this.valueDifferenceFound("Different value found in node \"%s\". Pattern %s did not match %s.", path, this.quoteTextValue(pattern), this.quoteTextValue(actualValue));
            }
        } else {
            this.compareValues(expectedValue, actualValue, path);
        }
    }

    private String getRegexPattern(String expectedValue) {
        return expectedValue.substring(REGEX_PLACEHOLDER.length());
    }

    private boolean isRegexExpected(String expectedValue) {
        return expectedValue.startsWith(REGEX_PLACEHOLDER);
    }

    private void compareValues(Object expectedValue, Object actualValue, String path) {
        if (!this.hasOption(Option.IGNORING_VALUES) && !expectedValue.equals(actualValue)) {
            this.valueDifferenceFound("Different value found in node \"%s\". Expected %s, got %s.", path, this.quoteTextValue(expectedValue), this.quoteTextValue(actualValue));
        }
    }

    private Object quoteTextValue(Object value) {
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        return value;
    }

    private void compareArrayNodes(Node expectedNode, Node actualNode, String path) {
        block10: {
            List<Node> actualElements;
            List<Node> expectedElements;
            block8: {
                ArrayList<Node> missingValues;
                block9: {
                    expectedElements = this.asList(expectedNode.arrayElements());
                    actualElements = this.asList(actualNode.arrayElements());
                    if (this.failOnExtraArrayItems()) {
                        if (expectedElements.size() != actualElements.size()) {
                            this.structureDifferenceFound("Array \"%s\" has different length. Expected %d, got %d.", path, expectedElements.size(), actualElements.size());
                        }
                    } else if (expectedElements.size() > actualElements.size()) {
                        this.structureDifferenceFound("Array \"%s\" has invalid length. Expected at least %d, got %d.", path, expectedElements.size(), actualElements.size());
                    }
                    ArrayList<Node> extraValues = new ArrayList<Node>();
                    missingValues = new ArrayList<Node>(expectedElements);
                    if (!this.hasOption(Option.IGNORING_ARRAY_ORDER)) break block8;
                    for (Node actual : actualElements) {
                        int index = this.indexOf(missingValues, actual);
                        if (index != -1) {
                            missingValues.remove(index);
                            continue;
                        }
                        extraValues.add(actual);
                    }
                    if (!this.failOnExtraArrayItems()) break block9;
                    if (!missingValues.isEmpty() || !extraValues.isEmpty()) {
                        this.valueDifferenceFound("Array \"%s\" has different content. Missing values %s, extra values %s", path, missingValues, extraValues);
                    }
                    break block10;
                }
                if (missingValues.isEmpty()) break block10;
                this.valueDifferenceFound("Array \"%s\" has different content. Missing values %s", path, missingValues);
                break block10;
            }
            for (int i = 0; i < Math.min(expectedElements.size(), actualElements.size()); ++i) {
                this.compareNodes(expectedElements.get(i), actualElements.get(i), this.getArrayPath(path, i));
            }
        }
    }

    private boolean failOnExtraArrayItems() {
        return !this.hasOption(Option.IGNORING_EXTRA_ARRAY_ITEMS);
    }

    private int indexOf(List<Node> expectedElements, Node actual) {
        int i = 0;
        for (Node expected : expectedElements) {
            Diff diff = new Diff(expected, actual, "", this.configuration);
            if (diff.similar()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private List<Node> asList(Iterator<Node> elements) {
        ArrayList<Node> result = new ArrayList<Node>();
        while (elements.hasNext()) {
            Node Node2 = elements.next();
            result.add(Node2);
        }
        return Collections.unmodifiableList(result);
    }

    private static String getPath(String parent, String name) {
        if (parent.length() == 0) {
            return name;
        }
        return parent + "." + name;
    }

    private String getArrayPath(String parent, int i) {
        if (parent.length() == 0) {
            return "[" + i + "]";
        }
        return parent + "[" + i + "]";
    }

    private void structureDifferenceFound(String message, Object ... arguments) {
        this.differences.add(message, arguments);
    }

    private void valueDifferenceFound(String message, Object ... arguments) {
        if (!this.hasOption(Option.COMPARING_ONLY_STRUCTURE)) {
            this.differences.add(message, arguments);
        }
    }

    private Set<String> commonFields(Map<String, Node> expectedFields, Map<String, Node> actualFields) {
        TreeSet<String> result = new TreeSet<String>(expectedFields.keySet());
        result.retainAll(actualFields.keySet());
        return Collections.unmodifiableSet(result);
    }

    private SortedSet<String> sort(Set<String> set) {
        return new TreeSet<String>(set);
    }

    public boolean similar() {
        this.compare();
        boolean result = this.differences.isEmpty();
        this.logDifferences(result);
        return result;
    }

    private void logDifferences(boolean result) {
        if (!result) {
            if (diffLogger.isDebugEnabled()) {
                diffLogger.debug(this.getDifferences().trim());
            }
            if (valuesLogger.isDebugEnabled()) {
                valuesLogger.debug("Comparing expected:\n{}\n------------\nwith actual:\n{}\n", (Object)this.expectedRoot, (Object)JsonUtils.getNode(this.actualRoot, this.startPath));
            }
        }
    }

    private static Map<String, Node> getFields(Node node) {
        HashMap<String, Node> result = new HashMap<String, Node>();
        Iterator<Node.KeyValue> fields = node.fields();
        while (fields.hasNext()) {
            Node.KeyValue field = fields.next();
            result.put(field.getKey(), field.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    public String toString() {
        return this.differences();
    }

    public String differences() {
        if (this.similar()) {
            return "JSON documents have the same value.";
        }
        return this.getDifferences();
    }

    private String getDifferences() {
        StringBuilder message = new StringBuilder();
        this.differences.appendDifferences(message);
        return message.toString();
    }
}

