/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.NullNode;

public class JsonUtils {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Pattern arrayPattern = Pattern.compile("(\\w*)\\[(\\d+)\\]");

    public static JsonNode readValue(String value, String label) {
        return JsonUtils.readValue(new StringReader(value), label);
    }

    public static JsonNode readValue(Reader value, String label) {
        try {
            return mapper.readTree(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not parse " + label + " value.", e);
        }
    }

    public static JsonNode convertToJson(Object source, String label) {
        if (source == null) {
            return NullNode.instance;
        }
        if (source instanceof JsonNode) {
            return (JsonNode)source;
        }
        if (source instanceof String) {
            return JsonUtils.readValue((String)source, label);
        }
        if (source instanceof Reader) {
            return JsonUtils.readValue((Reader)source, label);
        }
        return (JsonNode)mapper.convertValue(source, JsonNode.class);
    }

    public static JsonNode convertToJsonQuoteIfNeeded(Object source, String label) {
        if (source instanceof String) {
            return JsonUtils.convertToJson(JsonUtils.quoteIfNeeded((String)source), label);
        }
        return JsonUtils.convertToJson(source, label);
    }

    static JsonNode getNode(JsonNode root, String path) {
        if (path.length() == 0) {
            return root;
        }
        JsonNode startNode = root;
        StringTokenizer stringTokenizer = new StringTokenizer(path, ".");
        while (stringTokenizer.hasMoreElements()) {
            String step = stringTokenizer.nextToken();
            Matcher matcher = arrayPattern.matcher(step);
            if (!matcher.matches()) {
                startNode = startNode.path(step);
                continue;
            }
            if (matcher.group(1).length() != 0) {
                startNode = startNode.path(matcher.group(1));
            }
            startNode = startNode.path(Integer.valueOf(matcher.group(2)).intValue());
        }
        return startNode;
    }

    public static JsonNode getNode(Object root, String path) {
        return JsonUtils.getNode(JsonUtils.convertToJson(root, "actual"), path);
    }

    public static boolean nodeExists(Object json, String path) {
        return !JsonUtils.getNode(json, path).isMissingNode();
    }

    static String quoteIfNeeded(String source) {
        String trimmed = source.trim();
        if (JsonUtils.isObject(trimmed) || JsonUtils.isArray(trimmed) || JsonUtils.isString(trimmed) || JsonUtils.isBoolean(trimmed) || JsonUtils.isNull(trimmed) || JsonUtils.isNumber(trimmed)) {
            return source;
        }
        return "\"" + source + "\"";
    }

    public static Object quoteIfNeeded(Object source) {
        if (source instanceof String) {
            return JsonUtils.quoteIfNeeded((String)source);
        }
        return source;
    }

    private static boolean isNull(String trimmed) {
        return trimmed.equals("null");
    }

    private static boolean isBoolean(String trimmed) {
        return trimmed.equals("true") || trimmed.equals("false");
    }

    private static boolean isString(String trimmed) {
        return trimmed.startsWith("\"");
    }

    private static boolean isArray(String trimmed) {
        return trimmed.startsWith("[");
    }

    private static boolean isObject(String trimmed) {
        return trimmed.startsWith("{");
    }

    private static boolean isNumber(String source) {
        try {
            Double.parseDouble(source);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

