/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.NullNode;

public class JsonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static JsonNode readValue(String value, String label) {
        return JsonUtils.readValue(new StringReader(value), label);
    }

    public static JsonNode readValue(Reader value, String label) {
        try {
            return MAPPER.readTree(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not parse " + label + " value.", e);
        }
    }

    public static JsonNode convertToJson(Object source, String label) {
        if (source == null) {
            return NullNode.instance;
        }
        if (source instanceof JsonNode) {
            return (JsonNode)source;
        }
        if (source instanceof String) {
            return JsonUtils.readValue((String)source, label);
        }
        if (source instanceof Reader) {
            return JsonUtils.readValue((Reader)source, label);
        }
        return (JsonNode)MAPPER.convertValue(source, JsonNode.class);
    }

    public static JsonNode convertToJsonQuoteIfNeeded(Object source, String label) {
        if (source instanceof String) {
            return JsonUtils.convertToJson(JsonUtils.quoteIfNeeded((String)source), label);
        }
        return JsonUtils.convertToJson(source, label);
    }

    static String quoteIfNeeded(String source) {
        String trimmed = source.trim();
        if (JsonUtils.isObject(trimmed) || JsonUtils.isArray(trimmed) || JsonUtils.isString(trimmed) || JsonUtils.isBoolean(trimmed) || JsonUtils.isNull(trimmed) || JsonUtils.isNumber(trimmed)) {
            return source;
        }
        return "\"" + source + "\"";
    }

    public static Object quoteIfNeeded(Object source) {
        if (source instanceof String) {
            return JsonUtils.quoteIfNeeded((String)source);
        }
        return source;
    }

    private static boolean isNull(String trimmed) {
        return trimmed.equals("null");
    }

    private static boolean isBoolean(String trimmed) {
        return trimmed.equals("true") || trimmed.equals("false");
    }

    private static boolean isString(String trimmed) {
        return trimmed.startsWith("\"");
    }

    private static boolean isArray(String trimmed) {
        return trimmed.startsWith("[");
    }

    private static boolean isObject(String trimmed) {
        return trimmed.startsWith("{");
    }

    private static boolean isNumber(String source) {
        try {
            Double.parseDouble(source);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

