/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static JsonNode readValue(String value, String label) {
        return JsonUtils.readValue(new StringReader(value), label);
    }

    public static JsonNode readValue(Reader value, String label) {
        try {
            return MAPPER.readTree(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not parse " + label + " value.", e);
        }
    }

    public static JsonNode convertToJson(Object source, String label) {
        if (source instanceof JsonNode) {
            return (JsonNode)source;
        }
        if (source instanceof String) {
            return JsonUtils.readValue((String)source, label);
        }
        if (source instanceof Reader) {
            return JsonUtils.readValue((Reader)source, label);
        }
        return (JsonNode)MAPPER.convertValue(source, JsonNode.class);
    }
}

