/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.assertj;

import java.util.List;
import net.javacrumbs.jsonunit.assertj.JsonAssert;
import net.javacrumbs.jsonunit.assertj.JsonComparator;
import net.javacrumbs.jsonunit.assertj.JsonComparisonStrategy;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Path;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.FactoryBasedNavigableListAssert;
import org.assertj.core.api.InstanceOfAssertFactory;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.util.Lists;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonListAssert
extends FactoryBasedNavigableListAssert<JsonListAssert, List<?>, Object, JsonAssert> {
    private final Configuration configuration;
    private final Path path;

    JsonListAssert(List<?> actual, Path path, Configuration configuration) {
        super(actual, JsonListAssert.class, t -> new JsonAssert(path, configuration, t, true));
        this.path = path;
        this.configuration = configuration;
        this.usingComparator(new JsonComparator(configuration, path, true));
        this.usingElementComparator(new JsonComparator(configuration, path.asPrefix(), true));
    }

    @NotNull
    public JsonListAssert isEqualTo(@Nullable Object expected) {
        this.describedAs(null);
        Diff diff = this.createDiff(expected);
        diff.failIfDifferent();
        return this;
    }

    @NotNull
    public JsonListAssert isNotEqualTo(@Nullable Object other) {
        Diff diff = this.createDiff(other);
        if (diff.similar()) {
            JsonComparisonStrategy strategy = new JsonComparisonStrategy(this.configuration);
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nnot to be equal to:%n <%s>%n%s", new Object[]{this.actual, other, strategy}));
        }
        return this;
    }

    protected JsonListAssert newAbstractIterableAssert(Iterable<?> iterable) {
        return new JsonListAssert(Lists.newArrayList(iterable), this.path, this.configuration);
    }

    @Deprecated
    public <ASSERT extends AbstractAssert<?, ?>> ASSERT element(int index, InstanceOfAssertFactory<?, ASSERT> assertFactory) {
        return (ASSERT)super.element(index, assertFactory);
    }

    @Deprecated
    public <ASSERT extends AbstractAssert<?, ?>> ASSERT singleElement(InstanceOfAssertFactory<?, ASSERT> assertFactory) {
        return (ASSERT)super.singleElement(assertFactory);
    }

    public <ASSERT extends AbstractAssert<?, ?>> ASSERT asInstanceOf(InstanceOfAssertFactory<?, ASSERT> instanceOfAssertFactory) {
        throw this.failure("Please use isString(), isNumber(), isBoolean(), isNull(), isUri(), isArray() or isObject().%nThis method will most likely not provide the result you expect it to.", new Object[0]);
    }

    @Deprecated
    public <ASSERT extends AbstractAssert<?, ?>> ASSERT first(InstanceOfAssertFactory<?, ASSERT> assertFactory) {
        return (ASSERT)super.first(assertFactory);
    }

    @Deprecated
    public <ASSERT extends AbstractAssert<?, ?>> ASSERT last(InstanceOfAssertFactory<?, ASSERT> assertFactory) {
        return (ASSERT)super.last(assertFactory);
    }

    @NotNull
    private Diff createDiff(Object other) {
        return Diff.create((Object)other, (Object)JsonUtils.wrapDeserializedObject((Object)this.actual), (String)"fullJson", (Path)this.path, (Configuration)this.configuration);
    }
}

