/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.assertj;

import java.util.List;
import net.javacrumbs.jsonunit.assertj.JsonComparator;
import net.javacrumbs.jsonunit.assertj.JsonComparisonStrategy;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Path;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.ListAssert;
import org.assertj.core.error.ShouldNotBeEqual;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;

class JsonListAssert
extends ListAssert<Object> {
    private final Configuration configuration;
    private final Path path;

    JsonListAssert(List<?> actual, Path path, Configuration configuration) {
        super(actual);
        this.path = path;
        this.configuration = configuration;
        this.usingComparator(new JsonComparator(configuration, path, true));
        this.usingElementComparator(new JsonComparator(configuration, path.asPrefix(), true));
    }

    public JsonListAssert isEqualTo(Object expected) {
        this.describedAs(null);
        Diff diff = this.createDiff(expected);
        diff.failIfDifferent();
        return this;
    }

    public JsonListAssert isNotEqualTo(Object other) {
        Diff diff = this.createDiff(other);
        if (diff.similar()) {
            JsonComparisonStrategy strategy = new JsonComparisonStrategy(this.configuration);
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldNotBeEqual.shouldNotBeEqual((Object)this.actual, (Object)other, (ComparisonStrategy)strategy));
        }
        return this;
    }

    private Diff createDiff(Object other) {
        return Diff.create((Object)other, (Object)JsonUtils.wrapDeserializedObject((Object)this.actual), (String)"fullJson", (Path)this.path, (Configuration)this.configuration);
    }
}

