/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.assertj;

import net.javacrumbs.jsonunit.assertj.JsonComparator;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.Path;
import org.assertj.core.api.AbstractAssert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectAssert
extends AbstractAssert<JsonObjectAssert, Object> {
    private final Configuration configuration;
    private final Path path;

    JsonObjectAssert(Object actual, Path path, Configuration configuration) {
        super(actual, JsonObjectAssert.class);
        this.path = path;
        this.configuration = configuration;
        this.usingComparator(new JsonComparator(configuration, path.asPrefix(), true));
    }

    @NotNull
    public JsonObjectAssert isEqualTo(@Nullable Object expected) {
        return this.compare(expected, this.configuration);
    }

    @NotNull
    private UnsupportedOperationException unsupportedOperation() {
        return new UnsupportedOperationException("Operation not supported for JSON documents");
    }

    @NotNull
    private JsonObjectAssert compare(@Nullable Object other, @NotNull Configuration configuration) {
        this.describedAs(null);
        Diff diff = Diff.create((Object)other, (Object)this.actual, (String)"fullJson", (Path)this.path, (Configuration)configuration);
        diff.failIfDifferent();
        return this;
    }
}

