/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.futureconverter.springrx;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.ListenableFutureCallbackRegistry;
import rx.Observable;
import rx.functions.Action1;

class ObservableListenableFuture<T>
implements ListenableFuture<T> {
    private final Observable<T> observable;
    private final Future<T> futureFromObservable;
    private final ListenableFutureCallbackRegistry<T> callbackRegistry = new ListenableFutureCallbackRegistry();

    ObservableListenableFuture(Observable<T> wrapped) {
        this.observable = wrapped.asObservable();
        this.futureFromObservable = wrapped.doOnNext(new Action1<T>(){

            public void call(T t) {
                ObservableListenableFuture.this.callbackRegistry.success(t);
            }
        }).doOnError((Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                ObservableListenableFuture.this.callbackRegistry.failure(throwable);
            }
        }).toBlocking().toFuture();
    }

    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.callbackRegistry.addCallback(callback);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.futureFromObservable.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.futureFromObservable.isCancelled();
    }

    public boolean isDone() {
        return this.futureFromObservable.isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        return this.futureFromObservable.get();
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.futureFromObservable.get(timeout, unit);
    }

    public Observable<T> getObservable() {
        return this.observable;
    }
}

