/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.futureconverter.java8rx;

import java.util.concurrent.CompletableFuture;
import rx.Observable;

class CompletableFutureObservable<T>
extends Observable<T> {
    private final CompletableFuture<T> completableFuture;

    CompletableFutureObservable(CompletableFuture<T> completableFuture) {
        super(CompletableFutureObservable.onSubscribe(completableFuture));
        this.completableFuture = completableFuture;
    }

    private static <T> Observable.OnSubscribe<T> onSubscribe(CompletableFuture<T> completableFuture) {
        return subscriber -> ((CompletableFuture)completableFuture.thenAccept(value -> {
            if (!subscriber.isUnsubscribed()) {
                subscriber.onNext(value);
                subscriber.onCompleted();
            }
        })).exceptionally(throwable -> {
            if (!subscriber.isUnsubscribed()) {
                subscriber.onError(throwable);
            }
            return null;
        });
    }

    public CompletableFuture<T> getCompletableFuture() {
        return this.completableFuture;
    }
}

