/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.futureconverter.guavacommon;

import java.util.function.Consumer;
import net.javacrumbs.futureconverter.common.internal.ValueSource;
import rx.Single;
import rx.Subscription;
import rx.subscriptions.Subscriptions;

public class RxJavaFutureUtils {
    public static <T> Single<T> createSingle(ValueSource<T> valueSource) {
        if (valueSource instanceof SingleBackedValueSource) {
            return ((SingleBackedValueSource)valueSource).getSingle();
        }
        return new ValueSourceBackedSingle<T>(valueSource);
    }

    public static <T> ValueSource<T> createValueSource(Single<T> single) {
        if (single instanceof ValueSourceBackedSingle) {
            return ((ValueSourceBackedSingle)single).getValueSource();
        }
        return new SingleBackedValueSource(single);
    }

    private static class ValueSourceBackedSingle<T>
    extends Single<T> {
        private final ValueSource<T> valueSource;

        ValueSourceBackedSingle(ValueSource<T> valueSource) {
            super(ValueSourceBackedSingle.onSubscribe(valueSource));
            this.valueSource = valueSource;
        }

        private static <T> Single.OnSubscribe<T> onSubscribe(ValueSource<T> valueSource) {
            return subscriber -> {
                valueSource.addCallbacks(value -> {
                    if (!subscriber.isUnsubscribed()) {
                        try {
                            subscriber.onSuccess(value);
                        }
                        catch (Throwable e) {
                            subscriber.onError(e);
                        }
                    }
                }, throwable -> {
                    if (!subscriber.isUnsubscribed()) {
                        subscriber.onError(throwable);
                    }
                });
                subscriber.add(Subscriptions.create(() -> valueSource.cancel(true)));
            };
        }

        private ValueSource<T> getValueSource() {
            return this.valueSource;
        }
    }

    private static class SingleBackedValueSource<T>
    implements ValueSource<T> {
        private final Single<T> single;
        private Subscription subscription;

        private SingleBackedValueSource(Single<T> single) {
            this.single = single;
        }

        public void addCallbacks(Consumer<T> successCallback, Consumer<Throwable> failureCallback) {
            if (this.subscription != null) {
                throw new IllegalStateException("add callbacks can be called only once");
            }
            this.subscription = this.single.subscribe(successCallback::accept, failureCallback::accept);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            this.subscription.unsubscribe();
            return true;
        }

        private Single<T> getSingle() {
            return this.single;
        }
    }
}

