/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.UniqueObject;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.cio.Entry;

@ThreadSafe
public abstract class FsAbstractController
extends UniqueObject
implements FsController {
    private final FsModel model;

    protected FsAbstractController(FsModel model) {
        this.model = Objects.requireNonNull(model);
    }

    @Override
    public final FsModel getModel() {
        return this.model;
    }

    public final FsMountPoint getMountPoint() {
        return this.model.getMountPoint();
    }

    public final boolean isMounted() {
        return this.model.isMounted();
    }

    protected final void setMounted(boolean mounted) {
        this.model.setMounted(mounted);
    }

    @Override
    public boolean setTime(BitField<FsAccessOption> options, FsNodeName name, Map<Entry.Access, Long> times2) throws IOException {
        boolean ok = true;
        for (Map.Entry<Entry.Access, Long> e : times2.entrySet()) {
            long value2 = e.getValue();
            ok &= 0L <= value2 && this.setTime(options, name, BitField.of((Enum)e.getKey()), value2);
        }
        return ok;
    }

    public String toString() {
        return String.format("%s[model=%s]", this.getClass().getName(), this.getModel());
    }
}

