/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.zip.raes.crypto;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.PowerBuffer;
import net.java.truecommons.io.ReadOnlyChannel;
import net.java.truecommons.io.Source;
import net.java.truevfs.driver.zip.raes.crypto.RaesAuthenticationException;
import net.java.truevfs.driver.zip.raes.crypto.RaesException;
import net.java.truevfs.driver.zip.raes.crypto.RaesParameters;
import net.java.truevfs.driver.zip.raes.crypto.RaesParametersException;
import net.java.truevfs.driver.zip.raes.crypto.RaesParametersProvider;
import net.java.truevfs.driver.zip.raes.crypto.Type0RaesParameters;
import net.java.truevfs.driver.zip.raes.crypto.Type0RaesReadOnlyChannel;
import net.java.truevfs.key.spec.param.AesKeyStrength;

@NotThreadSafe
public abstract class RaesReadOnlyChannel
extends ReadOnlyChannel {
    @CreatesObligation
    public static RaesReadOnlyChannel create(RaesParameters param2, Source source) throws RaesParametersException, RaesException, EOFException, IOException {
        SeekableByteChannel channel2 = source.channel();
        try {
            return RaesReadOnlyChannel.create(param2, channel2);
        }
        catch (Throwable ex) {
            try {
                channel2.close();
            }
            catch (IOException ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
    }

    @CreatesObligation
    private static RaesReadOnlyChannel create(RaesParameters param2, @WillCloseWhenClosed SeekableByteChannel channel2) throws RaesParametersException, RaesException, EOFException, IOException {
        PowerBuffer header = PowerBuffer.allocate(5).littleEndian().load(channel2.position(0L));
        if (1397047634L != header.getUInt()) {
            throw new RaesException("No RAES signature!");
        }
        int type = header.getUByte();
        switch (type) {
            case 0: {
                return new Type0RaesReadOnlyChannel(RaesReadOnlyChannel.parameters(Type0RaesParameters.class, param2), channel2);
            }
        }
        throw new RaesException("Unknown RAES type: " + type);
    }

    private static <P extends RaesParameters> P parameters(Class<P> type, @CheckForNull RaesParameters param2) throws RaesParametersException {
        while (null != param2) {
            if (type.isInstance(param2)) {
                return (P)((RaesParameters)type.cast(param2));
            }
            if (!(param2 instanceof RaesParametersProvider)) break;
            param2 = ((RaesParametersProvider)param2).get(type);
        }
        throw new RaesParametersException("No suitable RAES parameters available!");
    }

    public abstract AesKeyStrength getKeyStrength();

    public abstract void authenticate() throws RaesAuthenticationException, IOException;
}

