/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.tardriver;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.DecoratingOutputStream;
import net.java.truecommons.io.DisconnectingOutputStream;
import net.java.truecommons.io.InputException;
import net.java.truecommons.io.Sink;
import net.java.truecommons.io.Streams;
import net.java.truecommons.shed.HashMaps;
import net.java.truecommons.shed.SuppressedExceptionBuilder;
import net.java.truevfs.comp.tardriver.TarDriver;
import net.java.truevfs.comp.tardriver.TarDriverEntry;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.cio.AbstractOutputSocket;
import net.java.truevfs.kernel.spec.cio.Entry;
import net.java.truevfs.kernel.spec.cio.InputSocket;
import net.java.truevfs.kernel.spec.cio.IoBuffer;
import net.java.truevfs.kernel.spec.cio.IoBufferPool;
import net.java.truevfs.kernel.spec.cio.OutputBusyException;
import net.java.truevfs.kernel.spec.cio.OutputService;
import net.java.truevfs.kernel.spec.cio.OutputSocket;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

@NotThreadSafe
public final class TarOutputService
implements OutputService<TarDriverEntry> {
    private final Map<String, TarDriverEntry> entries = new LinkedHashMap<String, TarDriverEntry>(HashMaps.initialCapacity(47));
    private final TarArchiveOutputStream taos;
    private final TarDriver driver;
    private boolean busy;

    @CreatesObligation
    public TarOutputService(FsModel model, Sink sink, TarDriver driver) throws IOException {
        Objects.requireNonNull(model);
        this.driver = Objects.requireNonNull(driver);
        OutputStream out = sink.stream();
        try {
            TarArchiveOutputStream taos = this.taos = new TarArchiveOutputStream(out, 10240, 512, driver.getEncoding());
            taos.setLongFileMode(driver.getLongFileMode());
        }
        catch (Throwable ex) {
            try {
                out.close();
            }
            catch (Throwable ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
    }

    private IoBufferPool getPool() {
        return this.driver.getPool();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Iterator<TarDriverEntry> iterator() {
        return Collections.unmodifiableCollection(this.entries.values()).iterator();
    }

    @Override
    @CheckForNull
    public TarDriverEntry entry(String name) {
        return this.entries.get(name);
    }

    @Override
    public OutputSocket<TarDriverEntry> output(final TarDriverEntry local) {
        Objects.requireNonNull(local);
        final class Output
        extends AbstractOutputSocket<TarDriverEntry> {
            Output() {
            }

            @Override
            public TarDriverEntry target() {
                return local;
            }

            @Override
            public OutputStream stream(InputSocket<? extends Entry> peer) throws IOException {
                if (TarOutputService.this.isBusy()) {
                    throw new OutputBusyException(local.getName());
                }
                if (local.isDirectory()) {
                    TarOutputService.this.updateProperties(local, DirectoryTemplate.INSTANCE);
                    return new EntryOutputStream(local);
                }
                TarOutputService.this.updateProperties(local, this.target(peer));
                return -1L == local.getSize() ? new BufferedEntryOutputStream(local) : new EntryOutputStream(local);
            }
        }
        return new Output();
    }

    void updateProperties(TarDriverEntry local, @CheckForNull Entry peer) {
        if (-1L == local.getModTime().getTime()) {
            local.setModTime(System.currentTimeMillis());
        }
        if (null != peer && -1L == local.getSize()) {
            local.setSize(peer.getSize(Entry.Size.DATA));
        }
    }

    private boolean isBusy() {
        return this.busy;
    }

    @Override
    public void close() throws IOException {
        this.taos.close();
    }

    @CleanupObligation
    private final class BufferedEntryOutputStream
    extends DecoratingOutputStream {
        final IoBuffer buffer;
        final TarDriverEntry local;
        boolean closed;

        @CreatesObligation
        BufferedEntryOutputStream(TarDriverEntry local) throws IOException {
            this.local = local;
            IoBuffer buffer = this.buffer = (IoBuffer)TarOutputService.this.getPool().allocate();
            try {
                this.out = buffer.output().stream(null);
            }
            catch (Throwable ex) {
                try {
                    buffer.release();
                }
                catch (Throwable ex2) {
                    ex.addSuppressed(ex2);
                }
                throw ex;
            }
            TarOutputService.this.entries.put(local.getName(), local);
            TarOutputService.this.busy = true;
        }

        @Override
        @DischargesObligation
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            TarOutputService.this.busy = false;
            this.out.close();
            TarOutputService.this.updateProperties(this.local, this.buffer);
            this.storeBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void storeBuffer() throws IOException {
            IoBuffer buffer = this.buffer;
            SuppressedExceptionBuilder builder = new SuppressedExceptionBuilder();
            try (InputStream in = buffer.input().stream(null);){
                TarArchiveOutputStream taos = TarOutputService.this.taos;
                taos.putArchiveEntry(this.local);
                try {
                    Streams.cat(in, taos);
                }
                catch (InputException ex) {
                    builder.warn(ex);
                }
                try {
                    taos.closeArchiveEntry();
                }
                catch (IOException ex) {
                    builder.warn(ex);
                }
            }
            catch (IOException ex) {
                builder.warn(ex);
            }
            finally {
                try {
                    buffer.release();
                }
                catch (IOException ex) {
                    builder.warn(ex);
                }
            }
            builder.check();
        }
    }

    @CleanupObligation
    private final class EntryOutputStream
    extends DisconnectingOutputStream {
        boolean closed;

        @CreatesObligation
        EntryOutputStream(TarDriverEntry local) throws IOException {
            super(TarOutputService.this.taos);
            TarOutputService.this.taos.putArchiveEntry(local);
            TarOutputService.this.entries.put(local.getName(), local);
            TarOutputService.this.busy = true;
        }

        @Override
        public boolean isOpen() {
            return !this.closed;
        }

        @Override
        @DischargesObligation
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            TarOutputService.this.busy = false;
            TarOutputService.this.taos.closeArchiveEntry();
        }
    }

    private static final class DirectoryTemplate
    implements Entry {
        static final DirectoryTemplate INSTANCE = new DirectoryTemplate();

        private DirectoryTemplate() {
        }

        @Override
        public String getName() {
            return "/";
        }

        @Override
        public long getSize(Entry.Size type) {
            return 0L;
        }

        @Override
        public long getTime(Entry.Access type) {
            return -1L;
        }

        @Override
        public Boolean isPermitted(Entry.Access type, Entry.Entity entity) {
            return null;
        }
    }
}

