/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.key.swing.util;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.EventListener;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.swing.JPanel;
import net.java.truevfs.key.swing.util.PanelEvent;
import net.java.truevfs.key.swing.util.PanelListener;

public class EnhancedPanel
extends JPanel {
    private static final long serialVersionUID = 6984576810262891640L;

    public EnhancedPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        super.addHierarchyListener(new EnhancedPanelHierarchyListener());
    }

    public EnhancedPanel(LayoutManager layout) {
        super(layout);
        super.addHierarchyListener(new EnhancedPanelHierarchyListener());
    }

    public EnhancedPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        super.addHierarchyListener(new EnhancedPanelHierarchyListener());
    }

    public EnhancedPanel() {
        super.addHierarchyListener(new EnhancedPanelHierarchyListener());
    }

    protected void processPanelEvent(PanelEvent event) {
        switch (event.getID()) {
            case 2000: {
                this.fireAncestorWindowShown(event);
                break;
            }
            case 2001: {
                this.fireAncestorWindowHidden(event);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Nullable
    public Window getAncestorWindow() {
        return EnhancedPanel.getAncestorWindow(this);
    }

    @Nullable
    private static Window getAncestorWindow(Component c) {
        while (null != c && !(c instanceof Window)) {
            c = c.getParent();
        }
        return (Window)c;
    }

    public void addPanelListener(PanelListener listener) {
        this.listenerList.add(PanelListener.class, (EventListener)Objects.requireNonNull(listener));
    }

    public void removePanelListener(PanelListener listener) {
        this.listenerList.remove(PanelListener.class, (EventListener)Objects.requireNonNull(listener));
    }

    public PanelListener[] getPanelListeners() {
        return (PanelListener[])this.getListeners(PanelListener.class);
    }

    void fireAncestorWindowShown(PanelEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PanelListener.class) continue;
            ((PanelListener)listeners[i + 1]).ancestorWindowShown(event);
        }
    }

    void fireAncestorWindowHidden(PanelEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PanelListener.class) continue;
            ((PanelListener)listeners[i + 1]).ancestorWindowHidden(event);
        }
    }

    private final class EnhancedPanelHierarchyListener
    implements HierarchyListener {
        private EnhancedPanelHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 4L) != 4L) {
                return;
            }
            Window window = EnhancedPanel.this.getAncestorWindow();
            assert (null != window) : "A showing panel must have a containing window!";
            boolean windowShown = window.isShowing();
            if (windowShown != EnhancedPanel.this.isShowing()) {
                return;
            }
            EnhancedPanel.this.processPanelEvent(new PanelEvent(EnhancedPanel.this, windowShown ? 2000 : 2001));
        }
    }
}

