/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.key.spec;

import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truevfs.key.spec.PromptingKeyProvider;
import net.java.truevfs.key.spec.SafeKey;
import net.java.truevfs.key.spec.SafeKeyManager;
import net.java.truevfs.key.spec.SafeKeyProvider;

@ThreadSafe
public class PromptingKeyManager<K extends SafeKey<K>>
extends SafeKeyManager<K, PromptingKeyProvider<K>> {
    private final PromptingKeyProvider.View<K> view;

    public PromptingKeyManager(PromptingKeyProvider.View<K> view) {
        this.view = Objects.requireNonNull(view);
    }

    final PromptingKeyProvider.View<K> getView() {
        return this.view;
    }

    @Override
    protected final PromptingKeyProvider<K> newKeyProvider() {
        return new PromptingKeyProvider(this);
    }

    @Override
    public final synchronized PromptingKeyProvider<K> make(URI resource) {
        PromptingKeyProvider provider = (PromptingKeyProvider)super.make(resource);
        provider.setResource(resource);
        return provider;
    }

    @Override
    @CheckForNull
    public final synchronized PromptingKeyProvider<K> get(URI resource) {
        PromptingKeyProvider provider = (PromptingKeyProvider)super.get(resource);
        if (null != provider) {
            provider.setResource(resource);
        }
        return provider;
    }

    @Override
    @CheckForNull
    public final synchronized PromptingKeyProvider<K> move(URI oldResource, URI newResource) {
        PromptingKeyProvider newProvider;
        PromptingKeyProvider oldProvider = (PromptingKeyProvider)super.move(oldResource, newResource);
        if (null != oldProvider) {
            oldProvider.setResource(null);
        }
        if (null != (newProvider = (PromptingKeyProvider)super.get(newResource))) {
            newProvider.setResource(newResource);
        }
        return oldProvider;
    }

    @Override
    @CheckForNull
    public final synchronized PromptingKeyProvider<K> delete(URI resource) {
        PromptingKeyProvider provider = (PromptingKeyProvider)super.delete(resource);
        if (null != provider) {
            provider.setResource(null);
        }
        return provider;
    }

    @Override
    public synchronized void unlock(URI resource) {
        SafeKeyProvider provider = this.get(resource);
        if (null != provider) {
            ((PromptingKeyProvider)provider).resetCancelledKey();
        }
    }

    @Override
    public String toString() {
        return String.format("%s[view=%s]", this.getClass().getName(), this.getView());
    }
}

