/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.file;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truevfs.driver.file.FileBuffer;
import net.java.truevfs.driver.file.FileNode;
import net.java.truevfs.kernel.spec.cio.IoBufferPool;

@ThreadSafe
final class FileBufferPool
extends IoBufferPool {
    private static final Path TEMP_DIR = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    private static final boolean IS_POSIX = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    private static final FileAttribute<Set<PosixFilePermission>> POSIX_PERMISSIONS = PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE}));
    private static final FileAttribute<?>[] POSIX_ATTRIBUTES = new FileAttribute[]{POSIX_PERMISSIONS};
    private static final FileAttribute<?>[] NO_ATTRIBUTES = new FileAttribute[0];
    @Nullable
    private final Path dir;
    private final String name;

    private static FileAttribute<?>[] attributes() {
        return IS_POSIX ? (FileAttribute[])POSIX_ATTRIBUTES.clone() : NO_ATTRIBUTES;
    }

    FileBufferPool() {
        this(null, null);
    }

    FileBufferPool(@CheckForNull Path dir, @CheckForNull String name) {
        this.dir = null != dir ? dir : TEMP_DIR;
        this.name = null != name ? name + "." : "tzp";
    }

    @Override
    public FileNode allocate() throws IOException {
        return new FileBuffer(Files.createTempFile(this.dir, this.name, null, FileBufferPool.attributes()), this);
    }
}

