/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import java.lang.ref.WeakReference;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class InheritableThreadLocalStack<T> {
    private final InheritableThreadLocal<Node<T>> nodes = new InheritableThreadLocal();

    public boolean isEmpty() {
        return null == this.nodes.get();
    }

    @Nullable
    public T peek() {
        Node node2 = (Node)this.nodes.get();
        return null != node2 ? (T)node2.element : null;
    }

    @Nullable
    public T peekOrElse(@CheckForNull T elze) {
        Node node2 = (Node)this.nodes.get();
        return null != node2 ? node2.element : elze;
    }

    @Nullable
    public T push(@CheckForNull T element) {
        Node previous = (Node)this.nodes.get();
        Node<T> next2 = new Node<T>(previous, element);
        this.nodes.set(next2);
        return element;
    }

    @Nullable
    public T pop() {
        Node node2 = (Node)this.nodes.get();
        if (null == node2) {
            throw new NoSuchElementException();
        }
        if (!Thread.currentThread().equals(node2.get())) {
            throw new NoSuchElementException();
        }
        this.nodes.set(node2.previous);
        return node2.element;
    }

    public void popIf(@CheckForNull T expected) {
        try {
            T got = this.pop();
            if (got != expected) {
                this.push(got);
                throw new IllegalStateException(got + " (expected " + expected + " as the top element of the inheritable thread local stack)");
            }
        }
        catch (NoSuchElementException ex) {
            throw new IllegalStateException("The inheritable thread local stack is empty!", ex);
        }
    }

    private static class Node<T>
    extends WeakReference<Thread> {
        @CheckForNull
        final Node<T> previous;
        @CheckForNull
        T element;

        Node(@CheckForNull Node<T> previous, @CheckForNull T element) {
            super(Thread.currentThread());
            this.previous = previous;
            this.element = element;
        }
    }
}

