/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.shed.QuotedUriSyntaxException;
import net.java.truecommons.shed.UriBuilder;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsUriModifier;

@Immutable
public final class FsNodePath
implements Serializable,
Comparable<FsNodePath> {
    private static final long serialVersionUID = 5798435461242930648L;
    private static final URI DOT = URI.create(".");
    @SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
    private URI uri;
    @Nullable
    private transient FsMountPoint mountPoint;
    private transient FsNodeName nodeName;
    @Nullable
    private volatile transient URI hierarchical;

    public static FsNodePath create(URI uri) {
        return FsNodePath.create(uri, FsUriModifier.NULL);
    }

    public static FsNodePath create(URI uri, FsUriModifier modifier) {
        try {
            return new FsNodePath(uri, modifier);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public FsNodePath(File file) {
        try {
            this.parse(file.toURI(), FsUriModifier.CANONICALIZE);
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @ConstructorProperties(value={"uri"})
    public FsNodePath(URI uri) throws URISyntaxException {
        this.parse(uri, FsUriModifier.NULL);
    }

    public FsNodePath(URI uri, FsUriModifier modifier) throws URISyntaxException {
        this.parse(uri, modifier);
    }

    public FsNodePath(@CheckForNull FsMountPoint mountPoint, FsNodeName nodeName) {
        if (null == mountPoint) {
            this.uri = nodeName.getUri();
        } else if (nodeName.isRoot()) {
            this.uri = mountPoint.getUri();
        } else {
            URI mpu = mountPoint.getUri();
            if (mpu.isOpaque()) {
                try {
                    String mpussp = mpu.getRawSchemeSpecificPart();
                    int mpusspl = mpussp.length();
                    URI enu = nodeName.getUri();
                    String enup = enu.getRawPath();
                    int enupl = enup.length();
                    String enuq = enu.getRawQuery();
                    int enuql = null == enuq ? 0 : enuq.length() + 1;
                    StringBuilder ssp = new StringBuilder(mpusspl + enupl + enuql).append(mpussp).append(enup);
                    if (null != enuq) {
                        ssp.append('?').append(enuq);
                    }
                    this.uri = new UriBuilder(true).scheme(mpu.getScheme()).path(ssp.toString()).fragment(enu.getRawFragment()).getUri();
                }
                catch (URISyntaxException ex) {
                    throw new AssertionError((Object)ex);
                }
            } else {
                this.uri = mpu.resolve(nodeName.getUri());
            }
        }
        this.mountPoint = mountPoint;
        this.nodeName = nodeName;
        assert (this.invariants());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.uri.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.parse(new URI(in.readObject().toString()), FsUriModifier.NULL);
        }
        catch (URISyntaxException ex) {
            throw (InvalidObjectException)new InvalidObjectException(ex.toString()).initCause(ex);
        }
    }

    private void parse(URI uri, FsUriModifier modifier) throws URISyntaxException {
        if (null != (uri = modifier.modify(uri, FsUriModifier.PostFix.NODE_PATH)).getRawFragment()) {
            throw new QuotedUriSyntaxException(uri, "Fragment component not allowed");
        }
        if (uri.isOpaque()) {
            URI mpu;
            URI nuri;
            String ssp = uri.getRawSchemeSpecificPart();
            int i = ssp.lastIndexOf("!/");
            if (0 > i) {
                throw new QuotedUriSyntaxException(uri, "Missing mount point separator \"!/\"");
            }
            UriBuilder b = new UriBuilder(true);
            this.mountPoint = new FsMountPoint(b.scheme(uri.getScheme()).path(ssp.substring(0, i + 2)).toUri(), modifier);
            this.nodeName = new FsNodeName(b.clear().pathQuery(ssp.substring(i + 2)).fragment(uri.getRawFragment()).toUri(), modifier);
            if (FsUriModifier.NULL != modifier && !uri.equals(nuri = new URI((mpu = this.mountPoint.getUri()).getScheme() + ':' + mpu.getRawSchemeSpecificPart() + this.nodeName.getUri()))) {
                uri = nuri;
            }
        } else if (uri.isAbsolute()) {
            this.mountPoint = new FsMountPoint(uri.resolve(DOT), modifier);
            this.nodeName = new FsNodeName(this.mountPoint.getUri().relativize(uri), modifier);
        } else {
            this.mountPoint = null;
            this.nodeName = new FsNodeName(uri, modifier);
            if (FsUriModifier.NULL != modifier) {
                uri = this.nodeName.getUri();
            }
        }
        this.uri = uri;
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (null != this.getUri());
        assert (null == this.getUri().getRawFragment());
        assert (null != this.getMountPoint() == this.getUri().isAbsolute());
        assert (null != this.getNodeName());
        if (this.getUri().isOpaque()) {
            assert (this.getUri().getRawSchemeSpecificPart().contains("!/"));
        } else if (this.getUri().isAbsolute()) {
            assert (this.getUri().normalize() == this.getUri());
            assert (this.getUri().equals(this.getMountPoint().getUri().resolve(this.getNodeName().getUri())));
        } else {
            assert (this.getUri().normalize() == this.getUri());
            assert (this.getNodeName().getUri() == this.getUri());
        }
        return true;
    }

    public URI getUri() {
        return this.uri;
    }

    public URI getHierarchicalUri() {
        URI hierarchical = this.hierarchical;
        if (null != hierarchical) {
            return hierarchical;
        }
        if (this.uri.isOpaque()) {
            URI mpu = this.mountPoint.getHierarchicalUri();
            URI enu = this.nodeName.getUri();
            try {
                this.hierarchical = enu.toString().isEmpty() ? mpu : new UriBuilder(mpu, true).path(mpu.getRawPath() + "/").getUri().resolve(enu);
                return this.hierarchical;
            }
            catch (URISyntaxException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        this.hierarchical = this.uri;
        return this.hierarchical;
    }

    @Nullable
    public FsMountPoint getMountPoint() {
        return this.mountPoint;
    }

    public FsNodeName getNodeName() {
        return this.nodeName;
    }

    public FsNodePath resolve(FsNodeName nodeName) {
        if (nodeName.isRoot() && null == this.uri.getQuery()) {
            return this;
        }
        return new FsNodePath(this.mountPoint, new FsNodeName(this.nodeName, nodeName));
    }

    @Override
    public int compareTo(FsNodePath that) {
        return this.uri.compareTo(that.uri);
    }

    public boolean equals(@CheckForNull Object that) {
        return this == that || that instanceof FsNodePath && this.uri.equals(((FsNodePath)that).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return this.uri.toString();
    }
}

