/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.ZipException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.io.AbstractSource;
import net.java.truecommons.io.LockInputStream;
import net.java.truecommons.io.OneTimeSource;
import net.java.truevfs.comp.zip.AbstractZipFile;
import net.java.truevfs.comp.zip.DefaultZipFileParameters;
import net.java.truevfs.comp.zip.ZipCryptoParameters;
import net.java.truevfs.comp.zip.ZipEntry;

@ThreadSafe
public class ZipFile
extends AbstractZipFile<ZipEntry> {
    protected final Lock lock = new ReentrantLock();
    private final String name;
    @CheckForNull
    private volatile ZipCryptoParameters cryptoParameters;

    public ZipFile(Path file) throws IOException {
        this(file, DEFAULT_CHARSET, true, false);
    }

    public ZipFile(Path file, Charset charset) throws IOException {
        this(file, charset, true, false);
    }

    public ZipFile(Path file, Charset charset, boolean preambled, boolean postambled) throws ZipException, EOFException, IOException {
        super(new ZipSource(file), new DefaultZipFileParameters(charset, preambled, postambled));
        this.name = file.toString();
    }

    public ZipFile(SeekableByteChannel channel2) throws IOException {
        this(channel2, DEFAULT_CHARSET, true, false);
    }

    public ZipFile(SeekableByteChannel channel2, Charset charset) throws IOException {
        this(channel2, charset, true, false);
    }

    public ZipFile(SeekableByteChannel channel2, Charset charset, boolean preambled, boolean postambled) throws ZipException, EOFException, IOException {
        super(new OneTimeSource(channel2), new DefaultZipFileParameters(charset, preambled, postambled));
        this.name = channel2.toString();
    }

    public ZipFile recoverLostEntries() throws IOException {
        super.recoverLostEntries();
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Enumeration<? extends ZipEntry> entries() {
        final class CloneEnumeration
        implements Enumeration<ZipEntry> {
            final Iterator<ZipEntry> i;

            CloneEnumeration() {
                this.i = ZipFile.super.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.i.hasNext();
            }

            @Override
            public ZipEntry nextElement() {
                return this.i.next().clone();
            }
        }
        return new CloneEnumeration();
    }

    @Override
    public Iterator<ZipEntry> iterator() {
        final class EntryIterator
        implements Iterator<ZipEntry> {
            final Iterator<ZipEntry> i;

            EntryIterator() {
                this.i = ZipFile.super.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public ZipEntry next() {
                return this.i.next().clone();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
        return new EntryIterator();
    }

    @Override
    public ZipEntry entry(String name) {
        Object ze = super.entry(name);
        return ze != null ? ((ZipEntry)ze).clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getPreambleInputStream() throws IOException {
        InputStream in;
        this.lock.lock();
        try {
            in = super.getPreambleInputStream();
        }
        finally {
            this.lock.unlock();
        }
        return new LockInputStream(this.lock, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getPostambleInputStream() throws IOException {
        InputStream in;
        this.lock.lock();
        try {
            in = super.getPostambleInputStream();
        }
        finally {
            this.lock.unlock();
        }
        return new LockInputStream(this.lock, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean busy() {
        this.lock.lock();
        try {
            boolean bl = super.busy();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Nullable
    public ZipCryptoParameters getCryptoParameters() {
        return this.cryptoParameters;
    }

    public void setCryptoParameters(@CheckForNull ZipCryptoParameters cryptoParameters) {
        this.cryptoParameters = cryptoParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InputStream getInputStream(String name, Boolean check2, boolean process) throws IOException {
        InputStream in;
        this.lock.lock();
        try {
            in = super.getInputStream(name, check2, process);
        }
        finally {
            this.lock.unlock();
        }
        return in == null ? null : new LockInputStream(this.lock, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            super.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    private static final class ZipSource
    extends AbstractSource {
        final Path file;

        ZipSource(Path file) {
            this.file = file;
        }

        @Override
        public SeekableByteChannel channel() throws IOException {
            return Files.newByteChannel(this.file, new OpenOption[0]);
        }
    }
}

