/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@CleanupObligation
@NotThreadSafe
public class ChannelOutputStream
extends OutputStream {
    private final ByteBuffer single = ByteBuffer.allocate(1);
    @Nullable
    protected WritableByteChannel channel;

    public ChannelOutputStream(@CheckForNull @WillCloseWhenClosed WritableByteChannel sbc) {
        this.channel = sbc;
    }

    @Override
    public void write(int b) throws IOException {
        this.single.put(0, (byte)b).clear();
        if (1 != this.channel.write(this.single)) {
            throw new IOException("write error");
        }
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len != this.channel.write(ByteBuffer.wrap(b, off, len))) {
            throw new IOException("write error");
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        this.channel.close();
    }
}

