/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.changes;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.changes.Change;
import org.apache.commons.compress.changes.ChangeSet;
import org.apache.commons.compress.changes.ChangeSetResults;
import org.apache.commons.compress.utils.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSetPerformer {
    private final Set<Change> changes;

    public ChangeSetPerformer(ChangeSet changeSet) {
        this.changes = changeSet.getChanges();
    }

    public ChangeSetResults perform(ArchiveInputStream in, ArchiveOutputStream out) throws IOException {
        ChangeSetResults results = new ChangeSetResults();
        LinkedHashSet<Change> workingSet = new LinkedHashSet<Change>(this.changes);
        Iterator it = workingSet.iterator();
        while (it.hasNext()) {
            Change change = (Change)it.next();
            if (change.type() != 2 || !change.isReplaceMode()) continue;
            this.copyStream(change.getInput(), out, change.getEntry());
            it.remove();
            results.addedFromChangeSet(change.getEntry().getName());
        }
        ArchiveEntry entry2 = null;
        while ((entry2 = in.getNextEntry()) != null) {
            boolean copy2 = true;
            Iterator it2 = workingSet.iterator();
            while (it2.hasNext()) {
                Change change = (Change)it2.next();
                int type = change.type();
                String name = entry2.getName();
                if (type == 1 && name != null) {
                    if (!name.equals(change.targetFile())) continue;
                    copy2 = false;
                    it2.remove();
                    results.deleted(name);
                    break;
                }
                if (type != 4 || name == null || !name.startsWith(change.targetFile() + "/")) continue;
                copy2 = false;
                results.deleted(name);
                break;
            }
            if (!copy2 || this.isDeletedLater(workingSet, entry2) || results.hasBeenAdded(entry2.getName())) continue;
            this.copyStream(in, out, entry2);
            results.addedFromStream(entry2.getName());
        }
        Iterator it3 = workingSet.iterator();
        while (it3.hasNext()) {
            Change change = (Change)it3.next();
            if (change.type() != 2 || change.isReplaceMode() || results.hasBeenAdded(change.getEntry().getName())) continue;
            this.copyStream(change.getInput(), out, change.getEntry());
            it3.remove();
            results.addedFromChangeSet(change.getEntry().getName());
        }
        out.finish();
        return results;
    }

    private boolean isDeletedLater(Set<Change> workingSet, ArchiveEntry entry2) {
        String source = entry2.getName();
        if (!workingSet.isEmpty()) {
            for (Change change : workingSet) {
                int type = change.type();
                String target2 = change.targetFile();
                if (type == 1 && source.equals(target2)) {
                    return true;
                }
                if (type != 4 || !source.startsWith(target2 + "/")) continue;
                return true;
            }
        }
        return false;
    }

    private void copyStream(InputStream in, ArchiveOutputStream out, ArchiveEntry entry2) throws IOException {
        out.putArchiveEntry(entry2);
        IOUtils.copy(in, out);
        out.closeArchiveEntry();
    }
}

