/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.shed.QuotedUriSyntaxException;
import net.java.truecommons.shed.UriBuilder;
import net.java.truevfs.kernel.spec.FsUriModifier;

@Immutable
public final class FsNodeName
implements Serializable,
Comparable<FsNodeName> {
    private static final long serialVersionUID = 3453442253468244275L;
    public static final String SEPARATOR = "/";
    public static final char SEPARATOR_CHAR = '/';
    private static final String ILLEGAL_PREFIX = "../";
    public static final FsNodeName ROOT;
    @SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
    private URI uri;

    public static FsNodeName create(URI uri) {
        return FsNodeName.create(uri, FsUriModifier.NULL);
    }

    public static FsNodeName create(URI uri, FsUriModifier modifier) {
        try {
            return uri.toString().isEmpty() ? ROOT : new FsNodeName(uri, modifier);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public FsNodeName(URI uri) throws URISyntaxException {
        this(uri, FsUriModifier.NULL);
    }

    public FsNodeName(URI uri, FsUriModifier modifier) throws URISyntaxException {
        this.parse(modifier.modify(uri, FsUriModifier.PostFix.NODE_NAME));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.uri.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.parse(new URI(in.readObject().toString()));
        }
        catch (URISyntaxException ex) {
            throw (InvalidObjectException)new InvalidObjectException(ex.toString()).initCause(ex);
        }
    }

    private void parse(URI uri) throws URISyntaxException {
        if (uri.isAbsolute()) {
            throw new QuotedUriSyntaxException(uri, "Scheme component defined.");
        }
        if (null != uri.getRawAuthority()) {
            throw new QuotedUriSyntaxException(uri, "Authority component defined.");
        }
        if (null == uri.getRawPath()) {
            throw new QuotedUriSyntaxException(uri, "Path component undefined.");
        }
        if (null != uri.getRawFragment()) {
            throw new QuotedUriSyntaxException(uri, "Fragment component defined.");
        }
        this.uri = uri;
        String p = uri.getRawPath();
        if (p.startsWith(SEPARATOR)) {
            throw new QuotedUriSyntaxException(uri, "Illegal start of URI path component");
        }
        if (!p.isEmpty() && ILLEGAL_PREFIX.startsWith(p.substring(0, Math.min(p.length(), ILLEGAL_PREFIX.length())))) {
            throw new QuotedUriSyntaxException(uri, "Illegal start of URI path component");
        }
        if (p.endsWith(SEPARATOR)) {
            throw new QuotedUriSyntaxException(uri, "Illegal separator \"/\" at end of URI path");
        }
        assert (this.invariants());
    }

    public FsNodeName(FsNodeName parent, FsNodeName member) {
        URI pu = parent.uri;
        String pup = pu.getRawPath();
        URI mu = member.uri;
        try {
            this.uri = pup.isEmpty() ? mu : (pup.endsWith(SEPARATOR) ? pu.resolve(mu) : (mu.getPath().isEmpty() ? new UriBuilder(pu, true).query(mu.getRawQuery()).getUri() : new UriBuilder(true).path(pup + '/').getUri().resolve(mu)));
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (null != this.toUri());
        assert (!this.toUri().isAbsolute());
        assert (null == this.toUri().getRawAuthority());
        assert (null != this.toUri().getRawPath());
        assert (null == this.toUri().getRawFragment());
        assert (this.toUri().normalize() == this.toUri());
        String p = this.toUri().getRawPath();
        assert (!"..".equals(p));
        assert (!p.startsWith(SEPARATOR));
        assert (!p.startsWith("./"));
        assert (!p.startsWith(ILLEGAL_PREFIX));
        assert (!p.endsWith(SEPARATOR));
        return true;
    }

    public boolean isRoot() {
        URI uri = this.toUri();
        String path = uri.getRawPath();
        if (null != path && !path.isEmpty()) {
            return false;
        }
        String query = uri.getRawQuery();
        return null == query;
    }

    public URI toUri() {
        return this.uri;
    }

    public String getPath() {
        return this.uri.getPath();
    }

    @CheckForNull
    public String getQuery() {
        return this.uri.getQuery();
    }

    @CheckForNull
    public String getFragment() {
        return this.uri.getFragment();
    }

    @Override
    public int compareTo(FsNodeName that) {
        return this.uri.compareTo(that.uri);
    }

    public boolean equals(@CheckForNull Object that) {
        return this == that || that instanceof FsNodeName && this.uri.equals(((FsNodeName)that).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return this.uri.toString();
    }

    static {
        try {
            ROOT = new FsNodeName(new URI(""));
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

