/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.UniqueObject;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsManager;
import net.java.truevfs.kernel.spec.FsSyncException;
import net.java.truevfs.kernel.spec.FsSyncExceptionBuilder;
import net.java.truevfs.kernel.spec.FsSyncOption;
import net.java.truevfs.kernel.spec.FsSyncWarningException;

@ThreadSafe
public abstract class FsAbstractManager
extends UniqueObject
implements FsManager {
    @Override
    public void sync(BitField<FsSyncOption> options) throws FsSyncWarningException, FsSyncException {
        if (options.get(FsSyncOption.ABORT_CHANGES)) {
            throw new IllegalArgumentException();
        }
        FsSyncExceptionBuilder builder = new FsSyncExceptionBuilder();
        for (FsController controller2 : this) {
            try {
                controller2.sync(options);
            }
            catch (FsSyncException ex) {
                builder.warn(ex);
            }
        }
        builder.check();
    }

    public String toString() {
        return String.format("%s@%x[size=%d]", this.getClass().getName(), this.hashCode(), this.size());
    }
}

