/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.odf;

import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truevfs.comp.zipdriver.JarDriverEntry;
import net.java.truevfs.comp.zipdriver.ZipOutputService;
import net.java.truevfs.kernel.spec.cio.DecoratingOutputSocket;
import net.java.truevfs.kernel.spec.cio.Entry;
import net.java.truevfs.kernel.spec.cio.InputSocket;
import net.java.truevfs.kernel.spec.cio.IoBufferPool;
import net.java.truevfs.kernel.spec.cio.MultiplexingOutputService;
import net.java.truevfs.kernel.spec.cio.OutputSocket;

@NotThreadSafe
public class OdfOutputService
extends MultiplexingOutputService<JarDriverEntry> {
    private static final String MIMETYPE = "mimetype";
    private boolean mimetype;

    public OdfOutputService(IoBufferPool pool, @WillCloseWhenClosed ZipOutputService<JarDriverEntry> output2) {
        super(pool, output2);
    }

    @Override
    public OutputSocket<JarDriverEntry> output(final JarDriverEntry entry2) {
        Objects.requireNonNull(entry2);
        final class Output
        extends DecoratingOutputSocket<JarDriverEntry> {
            Output() {
                super(OdfOutputService.super.output(jarDriverEntry));
            }

            @Override
            public JarDriverEntry target() throws IOException {
                return entry2;
            }

            @Override
            public OutputStream stream(InputSocket<? extends Entry> peer) throws IOException {
                if (OdfOutputService.MIMETYPE.equals(entry2.getName())) {
                    OdfOutputService.this.mimetype = true;
                    if (-1 == entry2.getMethod()) {
                        entry2.setMethod(0);
                    }
                }
                return this.socket().stream(peer);
            }
        }
        return new Output();
    }

    @Override
    public boolean isBusy() {
        return !this.mimetype || super.isBusy();
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        this.mimetype = true;
        super.close();
    }
}

