/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.file;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.driver.file.FileNode;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.cio.AbstractInputSocket;
import net.java.truevfs.kernel.spec.cio.Entry;
import net.java.truevfs.kernel.spec.cio.OutputSocket;

@NotThreadSafe
final class FileInputSocket
extends AbstractInputSocket<FileNode> {
    private final FileNode node;

    FileInputSocket(BitField<FsAccessOption> unused2, FileNode node2) {
        assert (null != node2);
        this.node = node2;
    }

    @Override
    public FileNode target() {
        return this.node;
    }

    @Override
    public InputStream stream(OutputSocket<? extends Entry> peer) throws IOException {
        return Files.newInputStream(this.node.getPath(), new OpenOption[0]);
    }

    @Override
    public SeekableByteChannel channel(OutputSocket<? extends Entry> peer) throws IOException {
        return Files.newByteChannel(this.node.getPath(), new OpenOption[0]);
    }
}

