/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truevfs.driver.file.FileBuffer;
import net.java.truevfs.driver.file.FileNode;
import net.java.truevfs.kernel.spec.cio.IoBufferPool;

@ThreadSafe
final class FileBufferPool
extends IoBufferPool {
    private static final Path TEMP_DIR = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    @Nullable
    private final Path dir;
    private final String name;

    FileBufferPool() {
        this(null, null);
    }

    FileBufferPool(@CheckForNull Path dir, @CheckForNull String name) {
        this.dir = null != dir ? dir : TEMP_DIR;
        this.name = null != name ? name + "." : "tzp";
    }

    @Override
    public FileNode allocate() throws IOException {
        return new FileBuffer(Files.createTempFile(this.dir, this.name, null, new FileAttribute[0]), this);
    }
}

